/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import java.util.Comparator;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class TaskAttemptResultStatisticsAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private final String[] headers = new String[]{"vertex (+task stats: all/succeeded/failed/killed)", "node", "status", "numAttempts"};
    private final Configuration config;
    private final CSVResult csvResult;

    public TaskAttemptResultStatisticsAnalyzer(Configuration config) {
        this.config = config;
        this.csvResult = new CSVResult(this.headers);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (VertexInfo vertex : dagInfo.getVertices()) {
            String taskStatsInVertex = String.format("%s/%s/%s/%s", vertex.getNumTasks(), vertex.getSucceededTasksCount(), vertex.getFailedTasksCount(), vertex.getKilledTasksCount());
            for (TaskAttemptInfo attempt : vertex.getTaskAttempts()) {
                String key2;
                Integer previousValue = (Integer)map.get(key2 = String.format("%s#%s#%s", String.format("%s (%s) (%s)", vertex.getVertexName(), vertex.getVertexId(), taskStatsInVertex), attempt.getNodeId(), attempt.getDetailedStatus()));
                map.put(key2, previousValue == null ? 1 : previousValue + 1);
            }
        }
        map.forEach((key, value) -> this.addARecord(key.split("#")[0], key.split("#")[1], key.split("#")[2], (int)value));
        this.csvResult.sort(new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                int vertexOrder = first[0].compareTo(second[0]);
                int nodeOrder = first[1].compareTo(second[1]);
                int statusOrder = first[2].compareTo(second[2]);
                return vertexOrder == 0 ? (nodeOrder == 0 ? statusOrder : nodeOrder) : vertexOrder;
            }
        });
    }

    private void addARecord(String vertexData, String node, String status, int numAttempts) {
        String[] record = new String[]{vertexData, node, status, Integer.toString(numAttempts)};
        this.csvResult.addRecord(record);
    }

    @Override
    public Result getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Task Attempt Result Statistics Analyzer";
    }

    @Override
    public String getDescription() {
        return "Get statistics about task attempts states in vertex:node:status level";
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        TaskAttemptResultStatisticsAnalyzer analyzer = new TaskAttemptResultStatisticsAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

