/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.client.util.YarnClientUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Master {
    public static String getMasterAddress(Configuration conf) {
        String masterAddress = conf.get("mapreduce.jobtracker.address", "localhost:8012");
        return NetUtils.createSocketAddr((String)masterAddress, (int)8012, (String)"mapreduce.jobtracker.address").getHostName();
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterPrincipal;
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            String masterAddress = Master.getMasterAddress(conf);
            masterPrincipal = SecurityUtil.getServerPrincipal((String)conf.get("mapreduce.jobtracker.kerberos.principal"), (String)masterAddress);
        } else {
            masterPrincipal = YarnClientUtils.getRmPrincipal((Configuration)conf);
        }
        return masterPrincipal;
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

