/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TaggedInputSplit;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingMapper<K1, V1, K2, V2>
extends Mapper<K1, V1, K2, V2> {
    private Mapper<K1, V1, K2, V2> mapper;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        TaggedInputSplit inputSplit = (TaggedInputSplit)context.getInputSplit();
        this.mapper = (Mapper)ReflectionUtils.newInstance(inputSplit.getMapperClass(), (Configuration)context.getConfiguration());
    }

    @Override
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.setup(context);
        this.mapper.run(context);
        this.cleanup(context);
    }
}

