/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWritable;

public class ProtoMessageReader<T extends MessageLite>
implements Closeable {
    private final Path filePath;
    private final SequenceFile.Reader reader;
    private final ProtoMessageWritable<T> writable;

    public ProtoMessageReader(Configuration conf, Path filePath, Parser<T> parser) throws IOException {
        this.filePath = filePath;
        this.reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)filePath), SequenceFile.Reader.length((long)Long.MAX_VALUE)});
        this.writable = new ProtoMessageWritable<T>(parser);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void setOffset(long offset) throws IOException {
        this.reader.seek(offset);
    }

    public long getOffset() throws IOException {
        return this.reader.getPosition();
    }

    public T readEvent() throws IOException {
        if (!this.reader.next((Writable)NullWritable.get(), this.writable)) {
            return null;
        }
        return this.writable.getMessage();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

