/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SplitMetaInfoReaderTez {
    public static final Logger LOG = LoggerFactory.getLogger(SplitMetaInfoReaderTez.class);
    public static final int META_SPLIT_VERSION = 1;
    public static final byte[] META_SPLIT_FILE_HEADER = JobSplit.META_SPLIT_FILE_HEADER;

    private static FSDataInputStream getFSDataIS(Configuration conf, FileSystem fs) throws IOException {
        long maxMetaInfoSize = conf.getLong("mapreduce.job.split.metainfo.maxsize", 10000000L);
        FSDataInputStream in = null;
        String basePath = conf.get("tez.mr.framework.task-local-resource.dir", ".");
        LOG.info("Attempting to find splits in dir: " + basePath);
        Path metaSplitFile = new Path(basePath, "job.splitmetainfo");
        File file = new File(metaSplitFile.toUri().getPath()).getAbsoluteFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting up JobSplitIndex with JobSplitFile at: " + file.getAbsolutePath() + ", defaultFS from conf: " + FileSystem.getDefaultUri((Configuration)conf));
        }
        FileStatus fStatus = null;
        try {
            fStatus = fs.getFileStatus(metaSplitFile);
            if (maxMetaInfoSize > 0L && fStatus.getLen() > maxMetaInfoSize) {
                throw new IOException("Split metadata size exceeded " + maxMetaInfoSize + ". Aborting job ");
            }
            in = fs.open(metaSplitFile);
            byte[] header = new byte[JobSplit.META_SPLIT_FILE_HEADER.length];
            in.readFully(header);
            if (!Arrays.equals(JobSplit.META_SPLIT_FILE_HEADER, header)) {
                throw new IOException("Invalid header on split file");
            }
            int vers = WritableUtils.readVInt((DataInput)in);
            if (vers != 1) {
                throw new IOException("Unsupported split version " + vers);
            }
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobSplit.TaskSplitMetaInfo[] readSplitMetaInfo(Configuration conf, FileSystem fs) throws IOException {
        try (FSDataInputStream in = null;){
            in = SplitMetaInfoReaderTez.getFSDataIS(conf, fs);
            String jobSplitFile = "job.split";
            String basePath = conf.get("tez.mr.framework.task-local-resource.dir", ".");
            int numSplits = WritableUtils.readVInt((DataInput)in);
            JobSplit.TaskSplitMetaInfo[] allSplitMetaInfo = new JobSplit.TaskSplitMetaInfo[numSplits];
            for (int i = 0; i < numSplits; ++i) {
                JobSplit.SplitMetaInfo splitMetaInfo = new JobSplit.SplitMetaInfo();
                splitMetaInfo.readFields((DataInput)in);
                JobSplit.TaskSplitIndex splitIndex = new JobSplit.TaskSplitIndex(new Path(basePath, "job.split").toUri().toString(), splitMetaInfo.getStartOffset());
                allSplitMetaInfo[i] = new JobSplit.TaskSplitMetaInfo(splitIndex, splitMetaInfo.getLocations(), splitMetaInfo.getInputDataLength());
            }
            JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfoArray = allSplitMetaInfo;
            return taskSplitMetaInfoArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobSplit.TaskSplitMetaInfo getSplitMetaInfo(Configuration conf, FileSystem fs, int index) throws IOException {
        try (FSDataInputStream in = null;){
            in = SplitMetaInfoReaderTez.getFSDataIS(conf, fs);
            String jobSplitFile = "job.split";
            String basePath = conf.get("tez.mr.framework.task-local-resource.dir", ".");
            int numSplits = WritableUtils.readVInt((DataInput)in);
            if (numSplits <= index) {
                throw new IOException("Index is larger than the number of splits");
            }
            JobSplit.SplitMetaInfo splitMetaInfo = new JobSplit.SplitMetaInfo();
            int iter = 0;
            while (iter++ <= index) {
                splitMetaInfo.readFields((DataInput)in);
            }
            JobSplit.TaskSplitIndex splitIndex = new JobSplit.TaskSplitIndex(new Path(basePath, "job.split").toUri().toString(), splitMetaInfo.getStartOffset());
            JobSplit.TaskSplitMetaInfo taskSplitMetaInfo = new JobSplit.TaskSplitMetaInfo(splitIndex, splitMetaInfo.getLocations(), splitMetaInfo.getInputDataLength());
            return taskSplitMetaInfo;
        }
    }
}

