/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.tez.runtime.api;

import org.apache.hadoop.classification.InterfaceAudience.Public;
import org.apache.hadoop.classification.InterfaceStability.Evolving;

/**
 * Report statistics about the {@link Output}
 */
@Public
@Evolving
public interface OutputStatisticsReporter {

  /**
   * Report the size of the logical data written
   * @param size of the data in bytes
   */
  public void reportDataSize(long size);

  /**
   * Report the number of items processed. These could be key-value pairs, table
   * records etc.
   * 
   * @param items
   *          number of items
   */
  public void reportItemsProcessed(long items);

}
