/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.util.StringInterner;

public class TezContainer
extends Container {
    public static final TezContainer NULL_TEZ_CONTAINER = new TezContainer(null);
    private final Container container;

    public TezContainer(Container container) {
        this.container = container;
    }

    public ContainerId getId() {
        return this.container != null ? this.container.getId() : null;
    }

    public void setId(ContainerId id) {
        this.container.setId(id);
    }

    public NodeId getNodeId() {
        return this.container != null ? this.container.getNodeId() : null;
    }

    public void setNodeId(NodeId nodeId) {
        this.container.setNodeId(nodeId);
    }

    public String getNodeHttpAddress() {
        return this.container != null ? StringInterner.intern((String)this.container.getNodeHttpAddress()) : null;
    }

    public void setNodeHttpAddress(String nodeHttpAddress) {
        this.container.setNodeHttpAddress(nodeHttpAddress);
    }

    public Map<String, List<Map<String, String>>> getExposedPorts() {
        return this.container.getExposedPorts();
    }

    public void setExposedPorts(Map<String, List<Map<String, String>>> ports) {
        this.container.setExposedPorts(ports);
    }

    public Resource getResource() {
        return this.container.getResource();
    }

    public void setResource(Resource resource) {
        this.container.setResource(resource);
    }

    public Priority getPriority() {
        return this.container.getPriority();
    }

    public void setPriority(Priority priority) {
        this.container.setPriority(priority);
    }

    public Token getContainerToken() {
        return this.container.getContainerToken();
    }

    public void setContainerToken(Token containerToken) {
        this.container.setContainerToken(containerToken);
    }

    public ExecutionType getExecutionType() {
        return this.container.getExecutionType();
    }

    public void setExecutionType(ExecutionType executionType) {
        this.container.setExecutionType(executionType);
    }

    public int compareTo(Container other) {
        if (this.getId().compareTo(other.getId()) == 0) {
            if (this.getNodeId().compareTo(other.getNodeId()) == 0) {
                return this.getResource().compareTo(other.getResource());
            }
            return this.getNodeId().compareTo(other.getNodeId());
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            Container otherContainer = ((TezContainer)((Object)other)).container;
            if (this.container == null && otherContainer == null) {
                return true;
            }
            if (this.container == null) {
                return false;
            }
            return this.container.equals(otherContainer);
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    public String getRackName() {
        return StringInterner.intern((String)RackResolver.resolve((String)this.container.getNodeId().getHost()).getNetworkLocation());
    }
}

