/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ShuffleHeader
implements Writable {
    public static final String HTTP_HEADER_NAME = "name";
    public static final String DEFAULT_HTTP_HEADER_NAME = "mapreduce";
    public static final String HTTP_HEADER_VERSION = "version";
    public static final String DEFAULT_HTTP_HEADER_VERSION = "1.0.0";
    private static final int MAX_ID_LENGTH = 1000;
    String mapId;
    long uncompressedLength;
    long compressedLength;
    int forReduce;

    public ShuffleHeader() {
    }

    public ShuffleHeader(String mapId, long compressedLength, long uncompressedLength, int forReduce) {
        this.mapId = mapId;
        this.compressedLength = compressedLength;
        this.uncompressedLength = uncompressedLength;
        this.forReduce = forReduce;
    }

    public String getMapId() {
        return this.mapId;
    }

    public int getPartition() {
        return this.forReduce;
    }

    public long getUncompressedLength() {
        return this.uncompressedLength;
    }

    public long getCompressedLength() {
        return this.compressedLength;
    }

    public void readFields(DataInput in) throws IOException {
        this.mapId = WritableUtils.readStringSafely((DataInput)in, (int)1000);
        this.compressedLength = WritableUtils.readVLong((DataInput)in);
        this.uncompressedLength = WritableUtils.readVLong((DataInput)in);
        this.forReduce = WritableUtils.readVInt((DataInput)in);
    }

    public int writeLength() throws IOException {
        int length = 0;
        int mapIdLength = Text.encode((String)this.mapId).limit();
        length += mapIdLength;
        length += WritableUtils.getVIntSize((long)mapIdLength);
        length += WritableUtils.getVIntSize((long)this.compressedLength);
        length += WritableUtils.getVIntSize((long)this.uncompressedLength);
        return length += WritableUtils.getVIntSize((long)this.forReduce);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.mapId);
        WritableUtils.writeVLong((DataOutput)out, (long)this.compressedLength);
        WritableUtils.writeVLong((DataOutput)out, (long)this.uncompressedLength);
        WritableUtils.writeVInt((DataOutput)out, (int)this.forReduce);
    }
}

