/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.event;

import org.apache.tez.dag.app.dag.event.DiagnosableEvent;
import org.apache.tez.dag.app.dag.event.RecoveryEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventTerminationCauseEvent;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskID;

public class TaskEventTermination
extends TaskEvent
implements DiagnosableEvent,
TaskAttemptEventTerminationCauseEvent,
RecoveryEvent {
    private final String diagnostics;
    private final TaskAttemptTerminationCause errorCause;
    private boolean fromRecovery;

    public TaskEventTermination(TezTaskID taskID, TaskAttemptTerminationCause errorCause, String diagnostics) {
        super(taskID, TaskEventType.T_TERMINATE);
        this.errorCause = errorCause;
        this.diagnostics = diagnostics != null ? diagnostics : "Task is terminated due to: " + errorCause.name();
    }

    public TaskEventTermination(TezTaskID taskID, TaskAttemptTerminationCause errorCause, String diagnostics, boolean fromRecovery) {
        this(taskID, errorCause, diagnostics);
        this.fromRecovery = fromRecovery;
    }

    @Override
    public String getDiagnosticInfo() {
        return this.diagnostics;
    }

    @Override
    public TaskAttemptTerminationCause getTerminationCause() {
        return this.errorCause;
    }

    @Override
    public boolean isFromRecovery() {
        return this.fromRecovery;
    }
}

