/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.utils;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.StringInterner;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Utils {
    private static final String LOG4J_CONFIGURATION = "log4j.configuration";
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static TezCounters parseTezCountersFromJSON(JSONObject jsonObject) throws JSONException {
        TezCounters counters = new TezCounters();
        if (jsonObject == null) {
            return counters;
        }
        JSONArray counterGroupNodes = jsonObject.optJSONArray("counterGroups");
        if (counterGroupNodes != null) {
            for (int i = 0; i < counterGroupNodes.length(); ++i) {
                JSONObject counterGroupNode = counterGroupNodes.optJSONObject(i);
                String groupName = counterGroupNode.optString("counterGroupName");
                String groupDisplayName = counterGroupNode.optString("counterGroupDisplayName", groupName);
                CounterGroup group = (CounterGroup)counters.addGroup(groupName, groupDisplayName);
                JSONArray counterNodes = counterGroupNode.optJSONArray("counters");
                for (int j = 0; j < counterNodes.length(); ++j) {
                    JSONObject counterNode = counterNodes.optJSONObject(j);
                    String counterName = counterNode.getString("counterName");
                    String counterDisplayName = counterNode.optString("counterDisplayName", counterName);
                    long counterValue = counterNode.getLong("counterValue");
                    Utils.addCounter(group, counterName, counterDisplayName, counterValue);
                }
            }
        }
        return counters;
    }

    private static void addCounter(CounterGroup group, String counterName, String displayName, long counterValue) {
        try {
            TezCounter counter = group.findCounter(counterName, displayName);
            counter.setValue(counterValue);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Error finding {} in {} with displayName {}", new Object[]{counterName, group, displayName});
        }
    }

    public static List<TaskAttemptInfo.DataDependencyEvent> parseDataEventDependencyFromJSON(JSONObject jsonObject) throws JSONException {
        ArrayList events = Lists.newArrayList();
        JSONArray fields = jsonObject.optJSONArray("lastDataEvents");
        for (int i = 0; i < fields.length(); ++i) {
            JSONObject eventMap = fields.getJSONObject(i);
            events.add(new TaskAttemptInfo.DataDependencyEvent(StringInterner.weakIntern((String)eventMap.optString(EntityTypes.TEZ_TASK_ATTEMPT_ID.name())), eventMap.optLong("ts")));
        }
        return events;
    }

    public static void parseEvents(JSONArray eventNodes, List<Event> eventList) throws JSONException {
        if (eventNodes == null) {
            return;
        }
        for (int i = 0; i < eventNodes.length(); ++i) {
            JSONObject eventNode = eventNodes.optJSONObject(i);
            String eventInfo = eventNode.optString("eventinfo");
            String eventType = eventNode.optString("eventtype");
            long time = eventNode.optLong("timestamp");
            Event event = new Event(eventInfo, eventType, time);
            eventList.add(event);
        }
    }

    public static void setupRootLogger() {
        if (Strings.isNullOrEmpty((String)System.getProperty(LOG4J_CONFIGURATION))) {
            org.apache.log4j.Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
            org.apache.log4j.Logger.getRootLogger().setLevel(Level.INFO);
        }
    }
}

