/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.netcdf.CRSMerger;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.provider.PseudoPlateCarree;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class GridMapping {
    final CoordinateReferenceSystem crs;
    private final MathTransform gridToCRS;
    private final boolean isWKT;

    private GridMapping(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, boolean bl) {
        this.crs = coordinateReferenceSystem;
        this.gridToCRS = mathTransform;
        this.isWKT = bl;
    }

    static GridMapping forVariable(Variable variable) {
        Map<Object, GridMapping> map = variable.decoder.gridMapping;
        for (String string : variable.decoder.convention().nameOfMappingNode(variable)) {
            GridMapping gridMapping = map.get(string);
            if (gridMapping != null) {
                return gridMapping;
            }
            if (map.containsKey(string)) continue;
            Node node = variable.decoder.findNode(string);
            if (node != null) {
                gridMapping = GridMapping.parse(node);
            }
            map.put(string, gridMapping);
            if (gridMapping == null) continue;
            return gridMapping;
        }
        Object object = map.get(variable);
        if (object == null) {
            String string;
            string = variable.getName();
            object = map.get(string);
            if (object == null && !map.containsKey(string)) {
                object = GridMapping.parse(variable);
                map.put(string, (GridMapping)object);
            }
            if (object == null) {
                object = GridMapping.parseNonStandard(variable);
            }
            if (object != null) {
                map.put(variable, (GridMapping)object);
            }
        }
        return object;
    }

    private static GridMapping parse(Node node) {
        GridMapping gridMapping = GridMapping.parseProjectionParameters(node);
        if (gridMapping == null) {
            gridMapping = GridMapping.parseGeoTransform(node);
        }
        return gridMapping;
    }

    private static GridMapping parseProjectionParameters(Node node) {
        Map<String, Object> map = node.decoder.convention().projection(node);
        if (map != null) {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6 = map.remove("longitude_of_prime_meridian");
                DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = node.decoder.getCoordinateOperationFactory();
                OperationMethod operationMethod = defaultCoordinateOperationFactory.getOperationMethod((String)map.remove("grid_mapping_name"));
                ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
                Object object7 = map.entrySet().iterator();
                while (object7.hasNext()) {
                    object5 = object7.next();
                    object4 = object5.getKey();
                    object3 = object5.getValue();
                    try {
                        if (object3 instanceof Number || object3 instanceof double[] || object3 instanceof float[]) {
                            object7.remove();
                            parameterValueGroup.parameter((String)object4).setValue(object3);
                            continue;
                        }
                        if (!(object3 instanceof String) || ((String)object4).endsWith("_name")) continue;
                        try {
                            object2 = parameterValueGroup.parameter((String)object4);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                        object = object2.getDescriptor().getValueClass();
                        if (Numbers.isNumber(object)) {
                            object7.remove();
                            object2.setValue(Double.parseDouble((String)object3));
                            continue;
                        }
                        if (!Numbers.isNumber(((Class)object).getComponentType())) continue;
                        object7.remove();
                        object2.setValue(GridMapping.parseDoubles((String)object3), null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        GridMapping.warning(node, illegalArgumentException, (short)20, node.decoder.getFilename(), node.getName(), object4, object3, illegalArgumentException.getLocalizedMessage());
                    }
                }
                object7 = GridMapping.createBaseCRS(node.decoder, parameterValueGroup, map, object6);
                if (operationMethod instanceof PseudoPlateCarree) {
                    object5 = MathTransforms.linear(new Matrix3(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
                    object4 = object7;
                } else {
                    object3 = GridMapping.properties(map, "conversion_name", node.getName());
                    object2 = defaultCoordinateOperationFactory.createDefiningConversion((Map<String, ?>)object3, operationMethod, parameterValueGroup);
                    object = node.decoder.getStandardProjectedCS();
                    object3 = GridMapping.properties(map, "projected_crs_name", object2);
                    ProjectedCRS projectedCRS = node.decoder.getCRSFactory().createProjectedCRS((Map<String, ?>)object3, (GeographicCRS)object7, (Conversion)object2, (CartesianCS)object);
                    object5 = projectedCRS.getConversionFromBase().getMathTransform();
                    object4 = projectedCRS;
                }
                if (!map.isEmpty()) {
                    GridMapping.warning(node, null, (short)25, node.decoder.getFilename(), String.join((CharSequence)", ", map.keySet()));
                }
                object3 = node.decoder.convention().gridToCRS(node, (MathTransform)object5);
                return new GridMapping((CoordinateReferenceSystem)object4, (MathTransform)object3, false);
            }
            catch (ClassCastException | IllegalArgumentException | TransformException | FactoryException exception) {
                GridMapping.canNotCreate(node, (short)11, exception);
            }
        }
        return null;
    }

    private static GeographicCRS createBaseCRS(Decoder decoder, ParameterValueGroup parameterValueGroup, Map<String, Object> map, Object object) throws FactoryException {
        Ellipsoid ellipsoid;
        Object object2;
        PrimeMeridian primeMeridian;
        Object object3;
        DatumFactory datumFactory = decoder.getDatumFactory();
        CommonCRS commonCRS = decoder.convention().defaultHorizontalCRS(false);
        boolean bl = false;
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            object3 = GridMapping.properties(map, "prime_meridian_name", d == 0.0 ? "Greenwich" : null);
            primeMeridian = datumFactory.createPrimeMeridian((Map<String, ?>)object3, d, Units.DEGREE);
            bl = true;
        } else {
            primeMeridian = commonCRS.primeMeridian();
        }
        try {
            double d;
            object2 = parameterValueGroup.parameter("semi_major");
            object3 = object2.getUnit().asType(Length.class);
            double d2 = object2.doubleValue();
            boolean bl2 = parameterValueGroup.parameter("is_ivf_definitive").booleanValue();
            boolean bl3 = bl2 ? (d = parameterValueGroup.parameter("inverse_flattening").doubleValue()) == 0.0 || Double.isInfinite(d) : (d = parameterValueGroup.parameter("semi_minor").doubleValue((Unit<?>)object3)) == d2;
            Supplier<Object> supplier = () -> GridMapping.lambda$createBaseCRS$0(decoder, (Unit)object3, d2, bl3);
            Map<String, Object> map2 = GridMapping.properties(map, "reference_ellipsoid_name", supplier);
            ellipsoid = bl2 ? datumFactory.createFlattenedSphere(map2, d2, d, (Unit<Length>)object3) : datumFactory.createEllipsoid(map2, d2, d, (Unit<Length>)object3);
            bl = true;
        }
        catch (IllegalStateException | ParameterNotFoundException runtimeException) {
            ellipsoid = commonCRS.ellipsoid();
        }
        object2 = map.remove("towgs84");
        if (bl | object2 != null) {
            Map<String, Object> map3 = GridMapping.properties(map, "horizontal_datum_name", ellipsoid);
            if (object2 instanceof BursaWolfParameters) {
                map3 = new HashMap<String, Object>(map3);
                map3.put("bursaWolf", object2);
                bl = true;
            }
            object3 = datumFactory.createGeodeticDatum(map3, ellipsoid, primeMeridian);
        } else {
            object3 = commonCRS.datum();
        }
        if (bl) {
            Map<String, Object> map4 = GridMapping.properties(map, "geographic_crs_name", object3);
            return decoder.getCRSFactory().createGeographicCRS(map4, (GeodeticDatum)object3, commonCRS.geographic().getCoordinateSystem());
        }
        return commonCRS.geographic();
    }

    private static Map<String, Object> properties(Map<String, Object> map, String string, Object object) {
        Object object2 = map.remove(string);
        if (object2 == null) {
            object2 = object == null ? Vocabulary.format((short)208) : (object instanceof IdentifiedObject ? ((IdentifiedObject)object).getName() : (object instanceof Supplier ? ((Supplier)object).get() : object.toString()));
        }
        return Collections.singletonMap("name", object2);
    }

    private static GridMapping parseGeoTransform(Node node) {
        String string = node.getAttributeAsString("spatial_ref");
        String string2 = node.getAttributeAsString("GeoTransform");
        if (string == null && string2 == null) {
            return null;
        }
        short s = 11;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        AffineTransform2D affineTransform2D = null;
        try {
            if (string != null) {
                coordinateReferenceSystem = GridMapping.createFromWKT(node, string);
            }
            if (string2 != null) {
                s = 12;
                double[] dArray = GridMapping.parseDoubles(string2);
                if (dArray.length == 6) {
                    affineTransform2D = new AffineTransform2D(dArray[1], dArray[4], dArray[2], dArray[5], dArray[0], dArray[3]);
                } else {
                    GridMapping.canNotCreate(node, s, new DataStoreContentException(Errors.getResources(node.getLocale()).getString((short)133, 6, dArray.length)));
                }
            }
        }
        catch (NumberFormatException | ParseException exception) {
            GridMapping.canNotCreate(node, s, exception);
        }
        return new GridMapping(coordinateReferenceSystem, affineTransform2D, string != null);
    }

    private static double[] parseDoubles(String string) {
        return CharSequences.parseDoubles(string.replace(',', ' '), ' ');
    }

    private static GridMapping parseNonStandard(Node node) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        boolean bl;
        String string = node.getAttributeAsString("ESRI_pe_string");
        boolean bl2 = bl = string != null;
        if (!bl && (string = node.getAttributeAsString("EPSG_code")) == null) {
            return null;
        }
        try {
            coordinateReferenceSystem = bl ? GridMapping.createFromWKT(node, string) : CRS.forCode("EPSG:" + string);
        }
        catch (ClassCastException | ParseException | FactoryException exception) {
            GridMapping.canNotCreate(node, (short)11, exception);
            coordinateReferenceSystem = null;
        }
        return new GridMapping(coordinateReferenceSystem, null, bl);
    }

    private static CoordinateReferenceSystem createFromWKT(Node node, String string) throws ParseException {
        WKTFormat wKTFormat = new WKTFormat(node.getLocale(), node.decoder.getTimeZone());
        wKTFormat.setConvention(Convention.WKT1_COMMON_UNITS);
        CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)wKTFormat.parseObject(string);
        Warnings warnings = wKTFormat.getWarnings();
        if (warnings != null) {
            LogRecord logRecord = new LogRecord(Level.WARNING, warnings.toString());
            logRecord.setLoggerName("org.apache.sis.storage.netcdf");
            logRecord.setSourceClassName(Variable.class.getCanonicalName());
            logRecord.setSourceMethodName("getGridGeometry");
            node.decoder.listeners.warning(logRecord);
        }
        return coordinateReferenceSystem;
    }

    private static void canNotCreate(Node node, short s, Exception exception) {
        GridMapping.warning(node, exception, s, node.decoder.getFilename(), node.getName(), exception.getLocalizedMessage());
    }

    private static void warning(Node node, Exception exception, short s, Object ... objectArray) {
        NamedElement.warning(node.decoder.listeners, Variable.class, "getGridGeometry", exception, null, s, objectArray);
    }

    final GridGeometry createGridCRS(Variable variable) {
        List<Dimension> list = variable.getGridDimensions();
        long[] lArray = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            int n = lArray.length - 1 - i;
            lArray[i] = list.get(n).length();
        }
        return new GridGeometry(new GridExtent(null, null, lArray, false), PixelInCell.CELL_CENTER, this.gridToCRS, this.crs);
    }

    final GridGeometry adaptGridCRS(Variable variable, GridGeometry gridGeometry, PixelInCell pixelInCell) {
        Object object;
        Object object2;
        Object object3 = this.crs;
        int n = 0;
        boolean bl = true;
        if (gridGeometry.isDefined(1)) {
            object2 = gridGeometry.getCoordinateReferenceSystem();
            if (object3 == null) {
                object3 = object2;
            } else {
                object = object2.getCoordinateSystem();
                n = AxisDirections.indexOfColinear((CoordinateSystem)object, object3.getCoordinateSystem());
                if (n < 0 && (n = AxisDirections.indexOfColinear((CoordinateSystem)object, (object3 = AbstractCRS.castOrCopy((CoordinateReferenceSystem)object3).forConvention(AxesConvention.RIGHT_HANDED)).getCoordinateSystem())) < 0) {
                    n = 0;
                    if (this.isWKT && this.crs != null) {
                        object3 = this.crs;
                    }
                }
                try {
                    object3 = new CRSMerger(variable.decoder).replaceComponent((CoordinateReferenceSystem)object2, n, (CoordinateReferenceSystem)object3);
                }
                catch (FactoryException factoryException) {
                    GridMapping.canNotCreate(variable, (short)11, factoryException);
                    return null;
                }
                bl = object2.equals(object3);
                if (bl) {
                    object3 = object2;
                }
            }
        }
        object2 = this.gridToCRS;
        if (gridGeometry.isDefined(8)) {
            object = gridGeometry.getGridToCRS(pixelInCell);
            if (object2 == null) {
                object2 = object;
            } else {
                try {
                    int n2;
                    int n3 = 0;
                    MathTransform[] mathTransformArray = new MathTransform[3];
                    TransformSeparator transformSeparator = new TransformSeparator((MathTransform)object, variable.decoder.getMathTransformFactory());
                    if (n != 0) {
                        transformSeparator.addTargetDimensionRange(0, n);
                        mathTransformArray[n3++] = transformSeparator.separate();
                        transformSeparator.clear();
                    }
                    mathTransformArray[n3++] = object2;
                    int n4 = n + object2.getTargetDimensions();
                    if (n4 != (n2 = object.getTargetDimensions())) {
                        transformSeparator.addTargetDimensionRange(n4, n2);
                        mathTransformArray[n3++] = transformSeparator.separate();
                    }
                    if (object.equals(object2 = MathTransforms.compound(mathTransformArray = ArraysExt.resize(mathTransformArray, n3)))) {
                        object2 = object;
                    } else {
                        bl = false;
                    }
                }
                catch (FactoryException factoryException) {
                    GridMapping.canNotCreate(variable, (short)12, factoryException);
                    return null;
                }
            }
        }
        if (bl) {
            return gridGeometry;
        }
        return new GridGeometry(gridGeometry.getExtent(), pixelInCell, (MathTransform)object2, (CoordinateReferenceSystem)object3);
    }

    private static /* synthetic */ Object lambda$createBaseCRS$0(Decoder decoder, Unit unit, double d, boolean bl) {
        Locale locale = decoder.listeners.getLocale();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setMaximumFractionDigits(5);
        double d2 = unit.getConverterTo(Units.KILOMETRE).convert(d);
        StringBuffer stringBuffer = new StringBuffer().append(Vocabulary.getResources(locale).getString(bl ? (short)271 : 72)).append(bl ? " R=" : " a=");
        return numberFormat.format(d2, stringBuffer, new FieldPosition(0)).append(" km").toString();
    }
}

