/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.Deque;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sis.system.DelayedExecutor;
import org.apache.sis.system.DelayedRunnable;
import org.apache.sis.system.Reflect;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.Implementation;
import org.apache.sis.xml.Pooled;
import org.apache.sis.xml.PooledMarshaller;
import org.apache.sis.xml.PooledTemplate;
import org.apache.sis.xml.PooledUnmarshaller;
import org.apache.sis.xml.bind.AdapterReplacement;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.TypeRegistration;

public class MarshallerPool {
    private static final long TIMEOUT = 15000000000L;
    protected final JAXBContext context;
    private final Implementation implementation;
    private final ServiceLoader<AdapterReplacement> replacements;
    private final PooledTemplate template;
    private final Deque<Marshaller> marshallers;
    private final Deque<Unmarshaller> unmarshallers;
    private final AtomicBoolean isRemovalScheduled;

    public MarshallerPool(Map<String, ?> properties) throws JAXBException {
        this(TypeRegistration.getSharedContext(), TypeRegistration.getPrivateInfo(properties));
    }

    public MarshallerPool(JAXBContext context, Map<String, ?> properties) throws JAXBException {
        ArgumentChecks.ensureNonNull("context", context);
        this.context = context;
        this.replacements = ServiceLoader.load(AdapterReplacement.class, Reflect.getContextClassLoader());
        this.implementation = Implementation.detect(context);
        this.template = new PooledTemplate(properties, this.implementation);
        this.marshallers = new ConcurrentLinkedDeque<Marshaller>();
        this.unmarshallers = new ConcurrentLinkedDeque<Unmarshaller>();
        this.isRemovalScheduled = new AtomicBoolean();
    }

    private <T> void recycle(Deque<T> queue, T marshaller) {
        try {
            ((Pooled)marshaller).reset(this.template);
        }
        catch (JAXBException exception) {
            Logging.unexpectedException(Context.LOGGER, MarshallerPool.class, "recycle", exception);
            return;
        }
        queue.push(marshaller);
        this.scheduleRemoval();
    }

    private void scheduleRemoval() {
        if (this.isRemovalScheduled.compareAndSet(false, true)) {
            DelayedExecutor.schedule(new DelayedRunnable(System.nanoTime() + 30000000000L){

                @Override
                public void run() {
                    MarshallerPool.this.removeExpired();
                }
            });
        }
    }

    final void removeExpired() {
        this.isRemovalScheduled.set(false);
        long now = System.nanoTime();
        if (!MarshallerPool.removeExpired(this.marshallers, now) | !MarshallerPool.removeExpired(this.unmarshallers, now)) {
            this.scheduleRemoval();
        }
    }

    private static <T> boolean removeExpired(Deque<T> queue, long now) {
        T next;
        while ((next = queue.peekLast()) != null) {
            if (now - ((Pooled)next).resetTime < 15000000000L) {
                return false;
            }
            next = queue.pollLast();
            if (now - ((Pooled)next).resetTime >= 15000000000L) continue;
            queue.addLast(next);
            return false;
        }
        return true;
    }

    public Marshaller acquireMarshaller() throws JAXBException {
        Marshaller marshaller = this.marshallers.poll();
        if (marshaller == null) {
            marshaller = new PooledMarshaller(this.createMarshaller(), this.template);
        }
        return marshaller;
    }

    public Unmarshaller acquireUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.unmarshallers.poll();
        if (unmarshaller == null) {
            unmarshaller = new PooledUnmarshaller(this.createUnmarshaller(), this.template);
        }
        return unmarshaller;
    }

    final Unmarshaller acquireUnmarshaller(Map<String, ?> properties) throws JAXBException {
        Unmarshaller unmarshaller = this.acquireUnmarshaller();
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return unmarshaller;
    }

    public void recycle(Marshaller marshaller) {
        this.recycle(this.marshallers, marshaller);
    }

    public void recycle(Unmarshaller unmarshaller) {
        this.recycle(this.unmarshallers, unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        String key = this.implementation.indentKey;
        if (key != null) {
            marshaller.setProperty(key, CharSequences.spaces(2));
        }
        ServiceLoader<AdapterReplacement> serviceLoader = this.replacements;
        synchronized (serviceLoader) {
            for (AdapterReplacement adapter : this.replacements) {
                adapter.register(marshaller);
            }
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        ServiceLoader<AdapterReplacement> serviceLoader = this.replacements;
        synchronized (serviceLoader) {
            for (AdapterReplacement adapter : this.replacements) {
                adapter.register(unmarshaller);
            }
        }
        return unmarshaller;
    }
}

