package org.apache.stratum.scheduler;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.io.FileInputStream;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.strategy.DecapitalizeNameMapper;
import org.apache.commons.betwixt.strategy.DefaultPluralStemmer;
import org.apache.commons.configuration.PropertiesConfiguration;

/**
 * Test harness for the Scheduler
 *
 * @author <a href="mailto:john@zenplex.com">John Thorhauer</a>
 * @version $Id: TestScheduler.java 264731 2005-08-30 08:04:32Z henning $
 */
public class TestScheduler
        extends TestCase
{
    /** TODO: DOCUMENT ME! */
    private static final String XML = "src/test-conf/Scheduler.xml";

    /** TODO: DOCUMENT ME! */
    private static final String PROPERTIES = "src/test-conf/Scheduler.properties";

    /**
     * TODO: DOCUMENT ME!
     *
     * @param args TODO: DOCUMENT ME!
     */
    public static void main(String [] args)
    {
        TestRunner.run(suite());
    }

    /**
     * TODO: DOCUMENT ME!
     *
     * @return TODO: DOCUMENT ME!
     */
    public static Test suite()
    {
        return new TestSuite(TestScheduler.class);
    }

    /**
     * Creates a new TestScheduler object.
     *
     * @param testName TODO: DOCUMENT ME!
     */
    public TestScheduler(String testName)
    {
        super(testName);
    }

    /**
     * TODO: DOCUMENT ME!
     *
     * @throws Exception TODO: DOCUMENT ME!
     */
    public void testLoadXmlConfig()
            throws Exception
    {
        SchedulerConfig schedConf = new SchedulerConfig();
        FileInputStream in = new FileInputStream(new File(XML));

        // create a new BeanReader
        BeanReader reader = createBeanReader();

        SchedulerConfig schedConf2 = (SchedulerConfig) reader.parse(in);

        assertNotNull("scheduler should not be null.", schedConf2);
        assertEquals("there should be 2 job configurations", 2, schedConf2.getJobConfigs().size());
        assertEquals("there should be 2 triggers", 2, schedConf2.getTriggerConfigs().size());
        assertTrue("scheduler name should be scheduler1", schedConf2.getInstanceName().equals("scheduler1"));

        assertTrue("job name should be job1", ((JobConfig) (schedConf2.getJobConfigs().get(0))).getName().equals("job1"));
    }

    /**
     * TODO: DOCUMENT ME!
     *
     * @throws Exception TODO: DOCUMENT ME!
     */
    public void testRunScheduler()
            throws Exception
    {
        Scheduler sched = new Scheduler();
        PropertiesConfiguration conf = new PropertiesConfiguration(PROPERTIES);
        sched.configure(conf);

        try
        {
            sched.start();
            Thread.sleep(5000);
            sched.stop();
        }
        catch (InterruptedException e)
        {
            e.printStackTrace();
        }
    }

    // Implementation methods
    //-------------------------------------------------------------------------
    protected BeanReader createBeanReader()
            throws Exception
    {
        BeanReader reader = new BeanReader();
        reader.setXMLIntrospector(createXMLIntrospector());
        reader.registerBeanClass(SchedulerConfig.class);

        return reader;
    }

    /**
     * ### it would be really nice to move this somewhere shareable across Maven / Turbine projects. Maybe a static helper method -
     * question is what to call it???
     *
     * @return TODO: DOCUMENT ME!
     */
    protected XMLIntrospector createXMLIntrospector()
    {
        XMLIntrospector introspector = new XMLIntrospector();

        // set elements for attributes to true
        introspector.getConfiguration().setAttributesForPrimitives(false);

        // wrap collections in an XML element
        //introspector.setWrapCollectionsInElement(true);
        // turn bean elements first letter into lower case
        introspector.getConfiguration().setElementNameMapper(new DecapitalizeNameMapper());
        introspector.getConfiguration().setAttributeNameMapper(new DecapitalizeNameMapper());

        introspector.getConfiguration().setPluralStemmer(new DefaultPluralStemmer());

        return introspector;
    }
}
