/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.DefaultValidator;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.ValidationException;

public class StringValidator
extends DefaultValidator {
    protected String maskString = null;
    protected Pattern maskPattern = null;
    protected String maskMessage = null;

    public StringValidator(Map paramMap) throws InvalidMaskException {
        this.init(paramMap);
    }

    public StringValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("mask");
        if (constraint != null) {
            String param = constraint.getValue();
            this.setMask(param);
            this.maskMessage = constraint.getMessage();
        }
    }

    public boolean isValid(String testValue) {
        boolean valid = false;
        try {
            this.assertValidity(testValue);
            valid = true;
        }
        catch (ValidationException ve) {
            valid = false;
        }
        return valid;
    }

    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if ((this.required || StringUtils.isNotEmpty((String)testValue)) && this.maskPattern != null) {
            Perl5Matcher patternMatcher = new Perl5Matcher();
            boolean patternMatch = patternMatcher.matches(testValue, this.maskPattern);
            this.log.debug((Object)("Trying to match " + testValue + " to pattern " + this.maskString));
            if (!patternMatch) {
                this.errorMessage = this.maskMessage;
                throw new ValidationException(this.maskMessage);
            }
        }
    }

    public String getMask() {
        return this.maskString;
    }

    public void setMask(String mask) throws InvalidMaskException {
        Perl5Compiler patternCompiler = new Perl5Compiler();
        this.maskString = mask;
        int maskOptions = 0;
        try {
            this.log.debug((Object)("Compiling pattern " + this.maskString));
            this.maskPattern = patternCompiler.compile(this.maskString, maskOptions);
        }
        catch (MalformedPatternException mpe) {
            throw new InvalidMaskException("Could not compile pattern " + this.maskString, mpe);
        }
    }

    public String getMaskMessage() {
        return this.maskMessage;
    }

    public void setMaskMessage(String message) {
        this.maskMessage = message;
    }
}

