/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;

public abstract class DefaultValidator<T>
implements Validator<T>,
InitableByConstraintMap,
LogEnabled {
    protected boolean required = false;
    protected String requiredMessage = null;
    protected int minLength = 0;
    protected String minLengthMessage = null;
    protected int maxLength = 0;
    protected String maxLengthMessage = null;
    protected String errorMessage = null;
    protected Logger log;

    public void enableLogging(Logger logger) {
        this.log = logger.getChildLogger(this.getClass().getSimpleName());
    }

    @Override
    public void init(Map<String, ? extends Constraint> paramMap) throws InvalidMaskException {
        String param;
        Constraint constraint = paramMap.get("required");
        if (constraint != null) {
            param = constraint.getValue();
            this.required = Boolean.valueOf(param);
            this.requiredMessage = constraint.getMessage();
        }
        if ((constraint = paramMap.get("minLength")) != null) {
            param = constraint.getValue();
            this.minLength = Integer.parseInt(param);
            this.minLengthMessage = constraint.getMessage();
        }
        if ((constraint = paramMap.get("maxLength")) != null) {
            param = constraint.getValue();
            this.maxLength = Integer.parseInt(param);
            this.maxLengthMessage = constraint.getMessage();
        }
    }

    @Override
    public boolean isValid(Field<T> field) {
        boolean valid = false;
        try {
            this.assertValidity(field);
            valid = true;
        }
        catch (ValidationException ve) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void assertValidity(Field<T> field) throws ValidationException {
        if (field.isMultiValued()) {
            String[] stringValues = (String[])field.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i]);
            }
        } else {
            this.assertValidity((String)field.getTestValue());
        }
    }

    @Override
    public boolean isValid(String testValue) {
        boolean valid = false;
        try {
            this.assertValidity(testValue);
            valid = true;
        }
        catch (ValidationException ve) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void assertValidity(String testValue) throws ValidationException {
        if (!this.required && StringUtils.isEmpty((String)testValue)) {
            return;
        }
        if (this.required && StringUtils.isEmpty((String)testValue)) {
            this.errorMessage = this.requiredMessage;
            throw new ValidationException(this.requiredMessage);
        }
        if (this.minLength > 0 && testValue.length() < this.minLength) {
            this.errorMessage = this.minLengthMessage;
            throw new ValidationException(this.minLengthMessage);
        }
        if (this.maxLength > 0 && testValue.length() > this.maxLength) {
            this.errorMessage = this.maxLengthMessage;
            throw new ValidationException(this.maxLengthMessage);
        }
    }

    @Override
    public String getMessage() {
        String retValue = "";
        if (this.errorMessage != null) {
            retValue = this.errorMessage;
        }
        return retValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String requiredMessage) {
        this.requiredMessage = requiredMessage;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public String getMinLengthMessage() {
        return this.minLengthMessage;
    }

    public void setMinLengthMessage(String minLengthMessage) {
        this.minLengthMessage = minLengthMessage;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getMaxLengthMessage() {
        return this.maxLengthMessage;
    }

    public void setMaxLengthMessage(String maxLengthMessage) {
        this.maxLengthMessage = maxLengthMessage;
    }
}

