package org.apache.turbine.test;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


import java.util.Locale;

import com.mockobjects.servlet.MockHttpServletRequest;

/**
 * Extension to the basic MockHttpServletRequest to provide some extra parameters
 * required by Turbine.
 *
 * @author <a href="mailto:epugh@upstate.com">Eric Pugh</a>
 * @version $Id: EnhancedMockHttpServletRequest.java 731294 2009-01-04 16:39:38Z tv $
 */
public class EnhancedMockHttpServletRequest extends MockHttpServletRequest
{
    /**
     *
     */
    public EnhancedMockHttpServletRequest()
    {
        super();
        // TODO Auto-generated constructor stub
    }
    
    /**
     * @see com.mockobjects.servlet.MockHttpServletRequest#getCharacterEncoding()
     */
    public String getCharacterEncoding()
    {
        return "US-ASCII";
    }

    /**
     * @see com.mockobjects.servlet.MockHttpServletRequest#getServerPort()
     */
    public int getServerPort()
    {
        return 8080;
    }

    /**
     * @see com.mockobjects.servlet.MockHttpServletRequest#getLocale()
     */
    public Locale getLocale()
    {
        return Locale.US;
    }

}
