/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.component;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.yaafi.framework.component.ServiceComponent;
import org.apache.fulcrum.yaafi.framework.role.RoleEntry;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public abstract class ServiceComponentImpl
implements ServiceComponent {
    private RoleEntry roleEntry;
    private Class<?> implementationClazz;
    private Object instance;
    private Object proxy;
    private Logger parentLogger;
    private Logger logger;
    private ServiceManager serviceManager;
    private Context context;
    private Configuration configuration;
    private Parameters parameters;

    public ServiceComponentImpl(RoleEntry roleEntry, Logger parentLogger, Logger logger) {
        Validate.notNull(roleEntry, "roleEntry");
        Validate.notNull(parentLogger, "parentLogger");
        Validate.notNull(logger, "logger");
        this.roleEntry = roleEntry;
        this.parentLogger = parentLogger;
        this.logger = logger;
    }

    @Override
    public void loadImplemtationClass(ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader currClassLoader = null;
        currClassLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        try {
            this.implementationClazz = currClassLoader.loadClass(this.getRoleEntry().getImplementationClazzName());
        }
        catch (ClassNotFoundException e) {
            String msg = "Failed to load the implementation class " + this.getRoleEntry().getImplementationClazzName();
            this.getParentLogger().error(msg, (Throwable)e);
            throw e;
        }
    }

    @Override
    public Object getInstance() throws Exception {
        if (!this.isInstantiated()) {
            this.createInstance();
            this.incarnateInstance();
        }
        return this.getRawInstance(true);
    }

    @Override
    public void incarnate() throws Exception {
        try {
            if (this.isEarlyInit()) {
                this.getInstance();
            }
        }
        catch (Throwable t) {
            String msg = "Failed initialize " + this.getRoleEntry().getImplementationClazzName();
            throw new ConfigurationException(msg, t);
        }
    }

    @Override
    public abstract void reconfigure() throws Exception;

    @Override
    public void decommision() throws Exception {
        this.instance = null;
        this.proxy = null;
    }

    @Override
    public void dispose() {
        this.roleEntry = null;
        this.implementationClazz = null;
        this.instance = null;
        this.proxy = null;
        this.parentLogger = null;
        this.logger = null;
        this.serviceManager = null;
        this.context = null;
        this.configuration = null;
        this.parameters = null;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public boolean isEarlyInit() {
        return this.getRoleEntry().isEarlyInit();
    }

    @Override
    public String getName() {
        return this.getRoleEntry().getName();
    }

    @Override
    public RoleEntry getRoleEntry() {
        return this.roleEntry;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Logger getParentLogger() {
        return this.parentLogger;
    }

    public Class<?> getImplementationClazz() {
        return this.implementationClazz;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Context getContext() {
        return this.context;
    }

    public Parameters getParamaters() {
        return this.parameters;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public String getShorthand() {
        return this.roleEntry.getShorthand();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("roleEntry", this.roleEntry);
        toStringBuilder.append("instance", this.instance);
        toStringBuilder.append("proxy", this.proxy);
        return toStringBuilder.toString();
    }

    protected final boolean isInstantiated() {
        return this.instance != null;
    }

    protected Object createInstance() throws InstantiationException, IllegalAccessException {
        if (this.getParentLogger().isDebugEnabled()) {
            this.getParentLogger().debug("Instantiating the implementation class for " + this.getShorthand());
        }
        this.instance = this.implementationClazz.newInstance();
        this.proxy = null;
        return this.instance;
    }

    protected abstract void incarnateInstance() throws Exception;

    protected Object getRawInstance(boolean useProxy) {
        if (useProxy && this.proxy != null) {
            return this.proxy;
        }
        return this.instance;
    }

    protected void setProxyInstance(Object proxy) {
        this.proxy = proxy;
    }
}

