/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.testing.ui.views.InfoPanel;
import org.apache.uima.ruta.testing.ui.views.ListContentProvider;
import org.apache.uima.ruta.testing.ui.views.ListDropAdapter;
import org.apache.uima.ruta.testing.ui.views.ListLabelProvider;
import org.apache.uima.ruta.testing.ui.views.TestCasData;
import org.apache.uima.ruta.testing.ui.views.evalDataTable.EvalTableContentProvider;
import org.apache.uima.ruta.testing.ui.views.evalDataTable.EvalTableLabelProvider;
import org.apache.uima.ruta.testing.ui.views.evalDataTable.TypeTableSorter;
import org.apache.uima.ruta.testing.ui.views.util.CASLoader;
import org.apache.uima.ruta.testing.ui.views.util.EvalDataProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;

public class TestViewPage
extends Page
implements IPageBookViewPage {
    private Composite overlay;
    private IResource script = null;
    private InfoPanel tInfoPanel;
    private TableViewer listviewer;
    private SashForm sash;
    private TableViewer tableViewer;
    private IPropertyChangeListener propertyChangeListener;
    private List<String> excludedTypes = new ArrayList<String>();
    private List<String> includedTypes = new ArrayList<String>();
    private ListLabelProvider labelProvider;

    public TestViewPage(Composite parent, IResource scriptResource) {
        this(scriptResource);
        this.overlay = new Composite(parent, 0);
        this.propertyChangeListener = null;
    }

    public TestViewPage(IResource scriptResource) {
        this.script = scriptResource;
    }

    public void createControl(Composite parent) {
        IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("LOAD_OLD_TEST_RESULTS") && event.getNewValue().toString().equals("true")) {
                    TestViewPage.this.loadExistingTests();
                }
            }
        };
        store.addPropertyChangeListener(this.propertyChangeListener);
        this.overlay = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        this.overlay.setLayout((Layout)gridLayout);
        GridData layoutData = new GridData(131072);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 3;
        layoutData.horizontalSpan = 1;
        this.tInfoPanel = new InfoPanel(this.overlay);
        GridData tInfoLabelData = new GridData();
        tInfoLabelData.grabExcessHorizontalSpace = true;
        tInfoLabelData.horizontalAlignment = 4;
        tInfoLabelData.horizontalSpan = 1;
        this.tInfoPanel.setLayoutData(tInfoLabelData);
        IPath path = this.script.getFullPath().removeFileExtension();
        String pathString = path.removeFirstSegments(2).toPortableString().replaceAll("[/]", ".");
        this.tInfoPanel.setFilename(pathString);
        this.sash = new SashForm(this.overlay, 256);
        this.sash.setLayoutData((Object)new GridData(1808));
        this.listviewer = new TableViewer((Composite)this.sash, 2818);
        this.labelProvider = new ListLabelProvider();
        this.listviewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        ListContentProvider provider = new ListContentProvider();
        this.listviewer.setContentProvider((IContentProvider)provider);
        this.listviewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int keyCode = e.keyCode;
                if (keyCode == 8 || keyCode == 127) {
                    List list = (List)TestViewPage.this.listviewer.getInput();
                    if (TestViewPage.this.listviewer.getSelection() instanceof StructuredSelection) {
                        StructuredSelection selection = (StructuredSelection)TestViewPage.this.listviewer.getSelection();
                        Iterator iter = selection.iterator();
                        while (iter.hasNext()) {
                            list.remove(iter.next());
                        }
                    }
                    TestViewPage.this.listviewer.refresh(false);
                }
            }
        });
        this.checkProjectTestStructure(this.script);
        this.loadExistingTests();
        this.listviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection obj = event.getSelection();
                if (obj instanceof IStructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)obj;
                    for (Object element : selection) {
                        if (!(element instanceof TestCasData)) continue;
                        TestCasData data = (TestCasData)element;
                        TestViewPage.this.updateSingleTestInformation(data);
                    }
                }
            }
        });
        this.listviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection obj = event.getSelection();
                if (obj instanceof IStructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)obj;
                    for (Object element : selection) {
                        TestCasData data;
                        if (!(element instanceof TestCasData) || (data = (TestCasData)element).getResultPath() == null) continue;
                        TestViewPage.this.openInCasEditor(data.getResultPath());
                    }
                }
            }
        });
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        int ops = 23;
        this.listviewer.addDropSupport(ops, transfers, (DropTargetListener)new ListDropAdapter(this.listviewer));
        GridData listData = new GridData();
        listData.horizontalAlignment = 4;
        listData.verticalAlignment = 4;
        listData.grabExcessHorizontalSpace = true;
        listData.grabExcessVerticalSpace = true;
        listData.horizontalSpan = 1;
        this.listviewer.getControl().setLayoutData((Object)listData);
        this.tableViewer = new TableViewer((Composite)this.sash);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EvalTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new EvalTableContentProvider());
        this.tableViewer.setSorter((ViewerSorter)new TypeTableSorter());
        Table table = this.tableViewer.getTable();
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText("Type");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(0);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText("TP");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(1);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText("FP");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(2);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText("FN");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(3);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText("Prec.");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(4);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText("Recall");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(5);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText("F1");
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TypeTableSorter)TestViewPage.this.tableViewer.getSorter()).doSort(6);
                TestViewPage.this.tableViewer.refresh();
            }
        });
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            table.getColumn(i).pack();
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected void openInCasEditor(IPath resultPath) {
        if (resultPath == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFileForLocation(resultPath);
        if (file != null && !file.isSynchronized(0)) {
            try {
                file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                RutaAddonsPlugin.error(e);
            }
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(file), "org.apache.uima.caseditor.editor");
            page.showView("org.apache.uima.ruta.testing.truePositive");
            page.showView("org.apache.uima.ruta.testing.falsePositive");
            page.showView("org.apache.uima.ruta.testing.falseNegative");
        }
        catch (PartInitException e) {
            RutaAddonsPlugin.error(e);
        }
    }

    public static Image createImage(String path) {
        return RutaAddonsPlugin.getImageDescriptor(path).createImage();
    }

    public void setResource(IResource r) {
        this.script = r;
    }

    public IResource getResource() {
        return this.script;
    }

    public TableViewer getViewer() {
        return this.listviewer;
    }

    public void updateInfoPanel() {
        if (this.listviewer.getInput() != null) {
            this.listviewer.refresh();
            int falsePositiveTotalCount = 0;
            int falseNegativeTotalCount = 0;
            int truePositiveTotalCount = 0;
            ArrayList dataList = (ArrayList)this.listviewer.getInput();
            for (TestCasData data : dataList) {
                falsePositiveTotalCount += data.getFalsePositiveCount();
                falseNegativeTotalCount += data.getFalseNegativeCount();
                truePositiveTotalCount += data.getTruePositiveCount();
            }
            this.tInfoPanel.setFP(falsePositiveTotalCount);
            this.tInfoPanel.setFN(falseNegativeTotalCount);
            this.tInfoPanel.setRuns(truePositiveTotalCount);
            double a = falsePositiveTotalCount;
            double b = falseNegativeTotalCount;
            double c = truePositiveTotalCount;
            double precision = c / (c + a);
            double recall = c / (c + b);
            double fMeasure = 2.0 * (precision * recall) / (precision + recall);
            fMeasure *= 1000.0;
            fMeasure = Math.round(fMeasure);
            this.tInfoPanel.setFMeasure(fMeasure /= 1000.0);
        }
    }

    public void saveState(IMemento memento) {
        List<String> it = this.getIncludedTypes();
        StringBuilder sb1 = new StringBuilder();
        for (String each : it) {
            sb1.append(each);
            sb1.append(";");
        }
        List<String> et = this.getExcludedTypes();
        StringBuilder sb2 = new StringBuilder();
        for (String each : et) {
            sb2.append(each);
            sb2.append(";");
        }
        if (memento != null) {
            memento.createChild("includedTypes", sb1.toString());
            memento.createChild("excludedTypes", sb2.toString());
        }
    }

    public void restoreState(IMemento memento) {
        IMemento etm;
        if (memento == null) {
            return;
        }
        IMemento itm = memento.getChild("includedTypes");
        if (itm != null) {
            String id = itm.getID();
            String[] split = id.split("");
            ArrayList<String> l = new ArrayList<String>();
            for (String string : split) {
                if (StringUtils.isBlank((CharSequence)string)) continue;
                l.add(string);
            }
            this.setIncludedTypes(l);
        }
        if ((etm = memento.getChild("excludedTypes")) != null) {
            String id = etm.getID();
            String[] split = id.split("");
            ArrayList<String> l = new ArrayList<String>();
            for (String string : split) {
                if (StringUtils.isBlank((CharSequence)string)) continue;
                l.add(string);
            }
            this.setExcludedTypes(l);
        }
    }

    public Control getControl() {
        return this.overlay;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void dispose() {
        this.overlay.dispose();
        this.labelProvider.dispose();
    }

    public void setFocus() {
        this.overlay.setFocus();
    }

    private void loadExistingTests() {
        IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
        IProject project = this.script.getProject();
        IPath testFolderPath = project.getFullPath().append(RutaProjectUtils.getDefaultTestLocation()).removeFirstSegments(1);
        IPath scriptPath = this.script.getFullPath();
        IPath scriptPackagePath = scriptPath.removeFirstSegments(2);
        IPath testFolderPackagePath = testFolderPath.append(scriptPackagePath).removeFileExtension();
        ArrayList<TestCasData> viewerInput = new ArrayList<TestCasData>();
        IFolder testFolder = project.getFolder(testFolderPackagePath);
        try {
            IResource[] resourceArray;
            for (IResource resource : resourceArray = testFolder.members()) {
                if (resource == null || !(resource instanceof IFile) || !resource.getLocation().getFileExtension().equals("xmi")) continue;
                TestCasData data = new TestCasData(resource.getLocation());
                if (Boolean.valueOf(store.getString("LOAD_OLD_TEST_RESULTS")).booleanValue()) {
                    data.loadPreviousResults(this.script);
                    CAS resultCas = CASLoader.loadCas(this.script, data.getResultPath());
                    EvalDataProcessor.calculateEvaluatData(data, resultCas);
                }
                viewerInput.add(data);
            }
        }
        catch (CoreException e) {
            RutaAddonsPlugin.error(e);
        }
        this.listviewer.setInput(viewerInput);
        this.listviewer.refresh();
    }

    private void checkProjectTestStructure(IResource r) {
        IProject project = r.getProject();
        IPath testFolderPath = project.getFullPath().append(RutaProjectUtils.getDefaultTestLocation()).removeFirstSegments(1);
        IPath scriptPath = r.getFullPath().removeFileExtension();
        IPath scriptPackagePath = scriptPath.removeFirstSegments(2);
        IPath testScriptPath = testFolderPath.append(scriptPackagePath);
        IPath resultPath = testScriptPath.append("results");
        IFolder resultFolder = project.getFolder(resultPath);
        IPath path2TempTests = project.getFullPath().append(RutaProjectUtils.getDefaultTestLocation()).append(RutaProjectUtils.getDefaultTempTestLocation()).removeFirstSegments(1);
        IFolder tempTestFolder = project.getFolder(path2TempTests);
        if (!project.exists(resultPath)) {
            try {
                CoreUtility.createFolder((IFolder)resultFolder, (boolean)true, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                RutaAddonsPlugin.error(e);
            }
        }
        if (!project.exists(path2TempTests)) {
            try {
                CoreUtility.createFolder((IFolder)tempTestFolder, (boolean)true, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                RutaAddonsPlugin.error(e);
            }
        }
    }

    public void updateSingleTestInformation(TestCasData data) {
        if (data.getTypeEvalData() != null) {
            this.tableViewer.setInput((Object)data.getTypeEvalData());
            for (TableColumn c : this.tableViewer.getTable().getColumns()) {
                c.pack();
            }
            this.tableViewer.refresh();
        }
    }

    public String getSelectedViewCasName() {
        return this.tInfoPanel.getSelectedViewCasName();
    }

    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    public List<String> getExcludedTypes() {
        return this.excludedTypes;
    }

    public void setIncludedTypes(List<String> includedTypes) {
        this.includedTypes = includedTypes;
    }

    public List<String> getIncludedTypes() {
        return this.includedTypes;
    }
}

