/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.codeassist;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.ide.core.codeassist.CompletionOnKeywordOrFunction;
import org.apache.uima.ruta.ide.core.codeassist.RutaAssistParser;
import org.apache.uima.ruta.ide.core.extensions.ICompletionExtension;
import org.apache.uima.ruta.ide.core.parser.RutaParseUtils;
import org.apache.uima.ruta.ide.parser.ast.RutaStatement;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.compiler.env.IModuleSource;

public class RutaCompletionParser
extends RutaAssistParser {
    private ICompletionExtension[] extensions;

    public RutaCompletionParser(ICompletionExtension[] extensions) {
        this.extensions = extensions;
    }

    public void handleNotInElement(ASTNode node, int position) {
        if (node != null && node.sourceStart() <= position && position <= node.sourceEnd()) {
            if (node instanceof ModuleDeclaration) {
                ModuleDeclaration unit = (ModuleDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                RutaEmptyCompleteStatement statement = new RutaEmptyCompleteStatement(exprs);
                unit.addStatement((ASTNode)statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)unit, position);
            } else if (node instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                RutaEmptyCompleteStatement statement = new RutaEmptyCompleteStatement(exprs);
                method.getStatements().add(statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)method, position);
            } else if (node instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                RutaEmptyCompleteStatement statement = new RutaEmptyCompleteStatement(exprs);
                type.getStatements().add(statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)type, position);
            }
        }
    }

    public void parseBlockStatements(ASTNode node, ASTNode inNode, int position) {
    }

    protected CompletionVisitor createCompletionVisitor(int position) {
        return new CompletionVisitor(position, this.getModule());
    }

    private void visitElements(ASTNode node, int position) {
        if (!(node instanceof RutaStatement)) {
            CompletionVisitor visitor = this.createCompletionVisitor(position);
            try {
                node.traverse((ASTVisitor)visitor);
            }
            catch (CompletionNodeFound e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkVariableWithoutDollarCompletion(RutaStatement statement, int position) {
        SimpleReference ref;
        String name;
        Expression e = statement.getAt(0);
        return e instanceof SimpleReference && (name = (ref = (SimpleReference)e).getName()).equals("set");
    }

    public String[] checkKeywords(String completionToken, int type) {
        return null;
    }

    public void setAssistNodeParent(ASTNode prevParent) {
        this.assistNodeParent = prevParent;
    }

    public ModuleDeclaration parse(IModuleSource sourceModule) {
        ModuleDeclaration module = (ModuleDeclaration)this.parser.parse(sourceModule, null);
        module.rebuild();
        return module;
    }

    public class CompletionVisitor
    extends ASTVisitor {
        protected int position;
        protected ModuleDeclaration module;

        public CompletionVisitor(int position, ModuleDeclaration module) {
            this.position = position;
            this.module = module;
        }

        public boolean visit(Statement s) throws Exception {
            return super.visit(s);
        }

        public boolean visit(Expression s) throws Exception {
            if (s.sourceStart() <= this.position && s.sourceEnd() >= this.position) {
                for (int i = 0; i < RutaCompletionParser.this.extensions.length; ++i) {
                    RutaCompletionParser.this.extensions[i].visit(s, RutaCompletionParser.this, this.position);
                }
            }
            return super.visit(s);
        }

        public boolean endvisit(Expression s) throws Exception {
            if (s instanceof Block && s.sourceStart() <= this.position && s.sourceEnd() >= this.position) {
                String[] keywords = RutaCompletionParser.this.checkKeywords("", 0);
                ASTNode inNode = RutaParseUtils.getScopeParent(this.module, s);
                CompletionOnKeywordOrFunction nde = new CompletionOnKeywordOrFunction("", inNode, (ASTNode)s, keywords);
                RutaCompletionParser.this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            return super.endvisit(s);
        }
    }

    private static class RutaEmptyCompleteStatement
    extends RutaStatement {
        public RutaEmptyCompleteStatement(List expressions) {
            super(expressions);
        }
    }
}

