/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.CasCache;
import org.apache.uima.ruta.textruler.core.CasCacheLoader;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocumentSet;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.util.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextRulerBasicLearner
implements TextRulerLearner,
CasCacheLoader {
    protected TextRulerLearnerDelegate delegate;
    protected AnalysisEngine ae;
    protected TextRulerExampleDocumentSet exampleDocuments;
    protected String inputDirectory;
    protected String tempDirectory;
    protected String preprocessorTMFile;
    protected Set<String> filterSet;
    protected Set<String> filterSetWithSlotNames;
    protected String[] slotNames;
    protected CasCache casCache;
    protected CAS algTestCAS;

    public TextRulerBasicLearner(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, TextRulerLearnerDelegate delegate) {
        this.preprocessorTMFile = prePropTMFile;
        this.tempDirectory = tmpDir;
        this.slotNames = slotNames;
        this.inputDirectory = inputDir;
        this.delegate = delegate;
        this.filterSet = filterSet;
        this.filterSetWithSlotNames = new HashSet<String>(filterSet);
        this.filterSetWithSlotNames.add("org.apache.uima.ruta.type.RutaBasic");
        for (String s : slotNames) {
            this.filterSetWithSlotNames.add(s);
            this.filterSetWithSlotNames.add(TextRulerTarget.getSingleSlotTypeName(TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY, s));
            this.filterSetWithSlotNames.add(TextRulerTarget.getSingleSlotTypeName(TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY, s));
        }
        this.casCache = new CasCache(100, this);
    }

    protected String tempDirectory() {
        return TextRulerToolkit.addTrailingSlashToPath(this.tempDirectory);
    }

    protected boolean shouldAbort() {
        if (this.delegate != null) {
            return this.delegate.shouldAbort();
        }
        return false;
    }

    @Override
    public AnalysisEngine getAnalysisEngine() {
        if (this.ae == null) {
            this.updateAE();
        }
        return this.ae;
    }

    private void updateAE() {
        String descriptorFile = TextRulerToolkit.getEngineDescriptorFromTMSourceFile((IPath)new Path(this.preprocessorTMFile));
        this.sendStatusUpdateToDelegate("loading AE...", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
        this.ae = TextRulerToolkit.loadAnalysisEngine(descriptorFile);
        String tempRulesFileName = this.getTempRulesFileName();
        Path path = new Path(tempRulesFileName);
        this.ae.setConfigParameterValue("mainScript", (Object)path.removeFileExtension().lastSegment());
        String portableString = path.removeLastSegments(1).toPortableString();
        this.ae.setConfigParameterValue("scriptPaths", (Object)new String[]{portableString});
        this.ae.setConfigParameterValue("additionalScripts", (Object)new String[0]);
        this.ae.setConfigParameterValue("reloadScript", (Object)true);
        try {
            this.ae.reconfigure();
        }
        catch (ResourceConfigurationException e) {
            TextRulerPlugin.error(e);
        }
    }

    protected boolean checkForMandatoryTypes() {
        CAS someCas = this.getTestCAS();
        TypeSystem ts = someCas.getTypeSystem();
        boolean result = true;
        ArrayList<String> missingTypes = new ArrayList<String>();
        for (String s : this.slotNames) {
            if (ts.getType(s) != null) continue;
            missingTypes.add(s);
            result = false;
        }
        String missingString = "";
        for (String string : missingTypes) {
            missingString = missingString + string + ", ";
        }
        if (!StringUtils.isEmpty((CharSequence)missingString)) {
            missingString = missingString.substring(0, missingString.length() - 2);
        }
        if (!result) {
            this.sendStatusUpdateToDelegate("Error: Some Slot- or Helper-Types were not found in TypeSystem: " + missingString, TextRulerLearner.TextRulerLearnerState.ML_ERROR, false);
        }
        return result;
    }

    protected boolean createTempDirIfNeccessary() {
        File dir = new File(this.tempDirectory());
        if (dir.exists() && dir.isDirectory()) {
            return true;
        }
        return dir.mkdir();
    }

    @Override
    public void run() {
        if (this.createTempDirIfNeccessary()) {
            this.updateAE();
            if (this.checkForMandatoryTypes()) {
                this.sendStatusUpdateToDelegate("Finding documents...", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
                this.exampleDocuments = new TextRulerExampleDocumentSet(this.inputDirectory, this.casCache);
                if (!this.shouldAbort()) {
                    this.sendStatusUpdateToDelegate("Starting...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
                    try {
                        this.doRun();
                    }
                    catch (Exception e) {
                        TextRulerPlugin.error(e);
                        this.sendStatusUpdateToDelegate("Aborted due to exception!", TextRulerLearner.TextRulerLearnerState.ML_ERROR, true);
                    }
                    this.cleanUp();
                }
            }
            this.casCache.clear();
            this.casCache = null;
            this.exampleDocuments = null;
            if (this.algTestCAS != null) {
                this.algTestCAS.reset();
                GlobalCASSource.releaseCAS(this.algTestCAS);
                this.algTestCAS = null;
            }
            if (this.shouldAbort()) {
                this.sendStatusUpdateToDelegate("Aborted!", TextRulerLearner.TextRulerLearnerState.ML_ABORTED, false);
            }
        } else {
            this.sendStatusUpdateToDelegate("ERROR CREATING TEMPORARY DIRECTORY!", TextRulerLearner.TextRulerLearnerState.ML_ERROR, false);
        }
    }

    @Override
    public CAS loadCAS(String fileName, CAS reuseCAS) {
        return TextRulerToolkit.readCASfromXMIFile(fileName, this.ae, reuseCAS);
    }

    protected void sendStatusUpdateToDelegate(String statusString, TextRulerLearner.TextRulerLearnerState state, boolean ruleBaseChanged) {
        if (this.delegate != null) {
            this.delegate.algorithmStatusUpdate(this, statusString, state, ruleBaseChanged);
        }
    }

    protected abstract void doRun();

    protected void cleanUp() {
    }

    public String getTempRulesFileName() {
        return this.tempDirectory() + "rules" + ".ruta";
    }

    public String getIntermediateRulesFileName() {
        return this.tempDirectory() + "intermediaterules" + ".ruta";
    }

    public void compareOriginalDocumentWithTestCAS(TextRulerExampleDocument originalDoc, CAS testCas, TextRulerTarget target, TextRulerStatisticsCollector c, boolean collectNegativeExamples) {
        List<TextRulerExample> originalPositives = originalDoc.getPositiveExamples();
        List<TextRulerExample> testPositives = originalDoc.createSlotInstancesForCAS(testCas, target, false);
        for (TextRulerExample e : testPositives) {
            TextRulerExample coveredExample = TextRulerToolkit.exampleListContainsAnnotation(originalPositives, e.getAnnotation());
            if (coveredExample != null) {
                c.addCoveredPositive(coveredExample);
                continue;
            }
            if (collectNegativeExamples) {
                e.setPositive(false);
                c.addCoveredNegative(e);
                continue;
            }
            c.incCoveredNegatives(1);
        }
    }

    public abstract boolean collectNegativeCoveredInstancesWhenTesting();

    public void testRuleOnDocument(TextRulerRule rule, TextRulerExampleDocument doc, TextRulerStatisticsCollector c) {
        CAS testCAS = this.getTestCAS();
        doc.resetAndFillTestCAS(testCAS, rule.getTarget());
        this.testRuleOnDocument(rule, doc, c, testCAS);
        testCAS.reset();
    }

    public void testRuleOnDocument(TextRulerRule rule, TextRulerExampleDocument doc, TextRulerStatisticsCollector c, CAS testCas) {
        try {
            rule.saveToRulesFile(this.getTempRulesFileName());
            this.ae.process(testCas);
            this.compareOriginalDocumentWithTestCAS(doc, testCas, rule.getTarget(), c, this.collectNegativeCoveredInstancesWhenTesting());
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
    }

    public void testRuleOnDocumentSet(TextRulerRule rule, TextRulerExampleDocumentSet documents) {
        TextRulerExampleDocument[] sortedDocs;
        TextRulerStatisticsCollector sum = new TextRulerStatisticsCollector();
        for (TextRulerExampleDocument theDoc : sortedDocs = documents.getSortedDocumentsInCacheOptimizedOrder()) {
            this.testRuleOnDocument(rule, theDoc, sum);
            if (this.shouldAbort()) break;
        }
        rule.setCoveringStatistics(sum);
    }

    public CAS applyScriptOnDocument(String script, TextRulerExampleDocument doc, TextRulerTarget target) {
        String tempRulesFileName = this.getTempRulesFileName();
        try {
            FileUtils.saveString2File((String)script, (File)new File(tempRulesFileName));
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
        }
        AnalysisEngine analysisEngine = this.getAnalysisEngine();
        CAS testCAS = this.getTestCAS();
        doc.resetAndFillTestCAS(testCAS, target);
        try {
            analysisEngine.process(testCAS);
        }
        catch (AnalysisEngineProcessException e) {
            TextRulerPlugin.error(e);
        }
        return testCAS;
    }

    /*
     * WARNING - void declaration
     */
    public void testRulesOnDocumentSet(List<? extends TextRulerRule> rules, TextRulerExampleDocumentSet documents) {
        void var7_10;
        if (rules.isEmpty()) {
            return;
        }
        ArrayList<TextRulerStatisticsCollector> sums = new ArrayList<TextRulerStatisticsCollector>();
        TextRulerExampleDocument[] sortedDocs = documents.getSortedDocumentsInCacheOptimizedOrder();
        TextRulerTarget target = rules.get(0).getTarget();
        for (TextRulerRule textRulerRule : rules) {
            sums.add(new TextRulerStatisticsCollector());
        }
        CAS theTestCAS = this.getTestCAS();
        for (TextRulerExampleDocument theDoc : sortedDocs) {
            for (int ruleIndex = 0; ruleIndex < rules.size(); ++ruleIndex) {
                TextRulerRule theRule = rules.get(ruleIndex);
                TextRulerStatisticsCollector sumC = (TextRulerStatisticsCollector)sums.get(ruleIndex);
                theDoc.resetAndFillTestCAS(theTestCAS, target);
                this.testRuleOnDocument(theRule, theDoc, sumC, theTestCAS);
                if (!this.shouldAbort()) continue;
                return;
            }
        }
        theTestCAS.reset();
        boolean bl = false;
        while (var7_10 < rules.size()) {
            rules.get((int)var7_10).setCoveringStatistics((TextRulerStatisticsCollector)sums.get((int)var7_10));
            ++var7_10;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testRulesOnDocument(List<? extends TextRulerRule> rules, TextRulerExampleDocument document) {
        void var6_10;
        void var6_8;
        if (rules.isEmpty()) {
            return;
        }
        ArrayList<TextRulerStatisticsCollector> sums = new ArrayList<TextRulerStatisticsCollector>();
        TextRulerTarget target = rules.get(0).getTarget();
        for (TextRulerRule textRulerRule : rules) {
            sums.add(new TextRulerStatisticsCollector());
        }
        CAS theTestCAS = this.getTestCAS();
        boolean bl = false;
        while (var6_8 < rules.size()) {
            TextRulerRule theRule = rules.get((int)var6_8);
            TextRulerStatisticsCollector sumC = (TextRulerStatisticsCollector)sums.get((int)var6_8);
            document.resetAndFillTestCAS(theTestCAS, target);
            this.testRuleOnDocument(theRule, document, sumC, theTestCAS);
            if (this.shouldAbort()) {
                return;
            }
            ++var6_8;
        }
        theTestCAS.reset();
        boolean bl2 = false;
        while (var6_10 < rules.size()) {
            rules.get((int)var6_10).setCoveringStatistics((TextRulerStatisticsCollector)sums.get((int)var6_10));
            ++var6_10;
        }
    }

    public String getTMFileHeaderString() {
        return this.getTMPackageString() + this.getTypeSystemImport() + this.getTMFilterCommandString();
    }

    private String getTypeSystemImport() {
        return "TYPESYSTEM " + this.getTypeSystemString(this.preprocessorTMFile) + ";\n\n";
    }

    private String getTypeSystemString(String fileString) {
        File file = new File(fileString);
        return "org.apache.uima.CompleteTypeSystemTypeSystem";
    }

    public String getTMPackageString() {
        return "PACKAGE org.apache.uima;\n\n";
    }

    public String getTMFilterCommandString() {
        if (this.filterSet != null && this.filterSet.size() > 0) {
            String fs = "";
            for (String s : this.filterSet) {
                if (fs.length() == 0) {
                    fs = fs + TextRulerToolkit.getTypeShortName(s);
                    continue;
                }
                fs = fs + ", " + TextRulerToolkit.getTypeShortName(s);
            }
            return "Document{->FILTERTYPE(" + fs + ")};\n\n";
        }
        return "";
    }

    @Override
    public CAS getTestCAS() {
        if (this.algTestCAS == null) {
            try {
                this.algTestCAS = GlobalCASSource.allocCAS(this.ae);
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
                return null;
            }
        }
        return this.algTestCAS;
    }

    protected void saveParametersToTempFolder(Map<String, Object> params) {
        if (this.createTempDirIfNeccessary()) {
            String str = "\nSettings:\n\n";
            str = str + "inputDir: " + this.inputDirectory;
            str = str + "\ntempDir: " + this.tempDirectory;
            str = str + "\npreprocessTMFile: " + this.preprocessorTMFile;
            str = str + "\n";
            for (Map.Entry<String, Object> e : params.entrySet()) {
                str = str + e.getKey() + " = " + e.getValue() + "\n";
            }
            if (this.createTempDirIfNeccessary()) {
                TextRulerToolkit.appendStringToFile(this.tempDirectory() + "settings.txt", str);
            }
        }
    }

    public Set<String> getFilterSet() {
        return this.filterSet;
    }
}

