/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.core.CasCache;
import org.apache.uima.ruta.textruler.core.CasCacheLoader;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

public class F1Scorer
implements CasCacheLoader {
    private AnalysisEngine ae;
    ArrayList<TextRulerExampleDocument> trainingDocuments;
    String[] testFileNames;

    public static String[] getXMIfileNames(String folderName) {
        File folder = new File(folderName);
        File[] files = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xmi");
            }
        });
        ArrayList<String> resultList = new ArrayList<String>();
        for (File f : files) {
            resultList.add(f.getAbsolutePath());
        }
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        Collections.sort(resultList, cmp);
        return resultList.toArray(new String[0]);
    }

    public F1Scorer(String descriptorFile, String trainingFolder, String testFolder) {
        this(TextRulerToolkit.loadAnalysisEngine(descriptorFile), trainingFolder, testFolder);
    }

    public F1Scorer(AnalysisEngine ae, String trainingFolder, String testFolder) {
        this.ae = ae;
        this.trainingDocuments = new ArrayList();
        CasCache casCache = new CasCache(5, this);
        for (String fileName : F1Scorer.getXMIfileNames(trainingFolder)) {
            this.trainingDocuments.add(new TextRulerExampleDocument(fileName, casCache));
        }
        this.testFileNames = F1Scorer.getXMIfileNames(testFolder);
    }

    public Score scoreSlot(String slotName) {
        Score result = new Score();
        TextRulerTarget target = new TextRulerTarget(slotName, null);
        result.slotName = slotName;
        int index = 0;
        CAS testCAS = null;
        for (TextRulerExampleDocument doc : this.trainingDocuments) {
            CAS exampleCAS = doc.getCAS();
            if (index >= this.testFileNames.length) {
                TextRulerToolkit.log("ABORTING DUE TO NON TEST-EXISTENT FILE! ");
                break;
            }
            if (!(testCAS = this.loadCAS(this.testFileNames[index], testCAS)).getDocumentText().equals(exampleCAS.getDocumentText())) {
                TextRulerToolkit.log("ERROR, EXAMPLE AND TEST DOCUMENT MISMATCH! WRONG FILE ORDER?");
                return null;
            }
            doc.clearCurrentExamples();
            doc.createExamplesForTarget(target);
            this.compareOriginalDocumentWithTestCAS(doc, testCAS, target, result);
            testCAS.reset();
            ++index;
        }
        testCAS.reset();
        GlobalCASSource.releaseCAS(testCAS);
        return result;
    }

    protected void compareOriginalDocumentWithTestCAS(TextRulerExampleDocument originalDoc, CAS testCas, TextRulerTarget target, Score theScore) {
        List<TextRulerExample> originalPositives = originalDoc.getPositiveExamples();
        List<TextRulerExample> testPositives = originalDoc.createSlotInstancesForCAS(testCas, target, true);
        for (TextRulerExample e : testPositives) {
            TextRulerExample coveredExample = TextRulerToolkit.exampleListContainsAnnotation(originalPositives, e.getAnnotation());
            if (coveredExample != null) {
                originalPositives.remove(coveredExample);
                ++theScore.tp;
                continue;
            }
            ++theScore.fp;
        }
        theScore.fn += originalPositives.size();
    }

    public static void main(String[] args) {
        F1Scorer scorer = new F1Scorer("/Users/tobi/Documents/runtime-EclipseApplication/MLSandBox/descriptor/org.apache.uima.ml/lp2validateEngine.xml", "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/Subset100/5fold/2/testing/withtags", "/Users/tobi/Documents/runtime-EclipseApplication/MLSandBox/output");
        Score score = scorer.scoreSlot("org.apache.uima.ml.types.stime");
        if (score != null) {
            score.logInfo();
        }
    }

    public CAS loadCAS(String fileName, CAS reuseCAS) {
        return TextRulerToolkit.readCASfromXMIFile(fileName, this.ae, reuseCAS);
    }

    public static class Score {
        public String slotName;
        public int tp;
        public int fp;
        public int fn;

        public void logInfo() {
            TextRulerToolkit.log(this.toString());
        }

        public String toString() {
            String str = "Slot: '" + this.slotName + "';  tp=" + this.tp + "\tfp=" + this.fp + "\tfn=" + this.fn + "\n";
            str = str + "\tPrecision: \t" + this.precision() + "\n";
            str = str + "\tRecall:    \t" + this.recall() + "\n";
            str = str + "\tF1 Score:  \t" + this.f1Score() + "\n";
            return str;
        }

        public double f1Score() {
            return Score.f1Score(this.precision(), this.recall());
        }

        public static double f1Score(double P, double R) {
            if (P + R == 0.0) {
                return 0.0;
            }
            return 2.0 * P * R / (P + R);
        }

        public double precision() {
            double v = this.tp + this.fp;
            if (v == 0.0) {
                return 0.0;
            }
            return (double)this.tp / v;
        }

        public double recall() {
            double v = this.tp + this.fn;
            if (v == 0.0) {
                return 0.0;
            }
            return (double)this.tp / v;
        }
    }
}

