/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.element;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.explain.element.ElementViewPage;
import org.apache.uima.ruta.explain.tree.ConditionNode;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.apache.uima.ruta.explain.tree.RuleElementMatchNode;
import org.apache.uima.ruta.explain.tree.RuleElementMatchesNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ElementTreeLabelProvider
extends LabelProvider
implements ILabelProvider {
    private ElementViewPage owner;

    public ElementTreeLabelProvider(ElementViewPage owner) {
        this.owner = owner;
    }

    public Image getImage(Object element) {
        if (element instanceof RuleElementMatchNode) {
            RuleElementMatchNode rem = (RuleElementMatchNode)element;
            boolean matched = rem.matched();
            return this.owner.getImage("org.apache.uima.ruta.type.DebugRuleElementMatch" + matched);
        }
        if (element instanceof RuleElementMatchesNode) {
            RuleElementMatchesNode rems = (RuleElementMatchesNode)element;
            boolean matched = rems.matched();
            return this.owner.getImage("org.apache.uima.ruta.type.DebugRuleElementMatches" + matched);
        }
        if (element instanceof ConditionNode) {
            ConditionNode rems = (ConditionNode)element;
            boolean matched = rems.matched();
            return this.owner.getImage("org.apache.uima.ruta.type.DebugEvaluatedCondition" + matched);
        }
        return this.owner.getImage("element");
    }

    public String getText(Object element) {
        if (element instanceof IExplainTreeNode) {
            IExplainTreeNode debugNode = (IExplainTreeNode)element;
            TypeSystem ts = debugNode.getTypeSystem();
            if (element instanceof RuleElementMatchesNode) {
                Type type = ts.getType("org.apache.uima.ruta.type.DebugRuleElementMatches");
                FeatureStructure fs = debugNode.getFeatureStructure();
                Feature f = type.getFeatureByBaseName("element");
                Feature fanchor = type.getFeatureByBaseName("ruleAnchor");
                if (f != null && fanchor != null) {
                    String v = fs.getStringValue(f);
                    String ruleAnchor = fs.getBooleanValue(fanchor) ? "@" : "";
                    return ruleAnchor + v;
                }
            } else if (element instanceof RuleElementMatchNode) {
                FeatureStructure fs = debugNode.getFeatureStructure();
                if (fs instanceof AnnotationFS) {
                    String s = ((AnnotationFS)fs).getCoveredText();
                    s = s.replaceAll("[\\n\\r]", "");
                    return s;
                }
            } else if (element instanceof ConditionNode) {
                Type type = ts.getType("org.apache.uima.ruta.type.DebugEvaluatedCondition");
                FeatureStructure fs = debugNode.getFeatureStructure();
                Feature f = type.getFeatureByBaseName("element");
                if (f != null) {
                    String v = fs.getStringValue(f);
                    return v;
                }
            }
        }
        return element.toString();
    }
}

