/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.internal.ui.forms;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormSection {
    public static Section createGridDataSection(FormToolkit toolkit, Composite parent, int sectionStyle, String title, String description, int marginWidth, int marginHeight, int layoutStyle, int horizontalSpan, int verticalSpan) {
        Section section = toolkit.createSection(parent, sectionStyle);
        section.setText(title);
        section.setDescription(description);
        section.marginWidth = marginWidth;
        section.marginHeight = marginHeight;
        GridData layoutData = new GridData(layoutStyle);
        layoutData.horizontalSpan = horizontalSpan;
        layoutData.verticalSpan = verticalSpan;
        section.setLayoutData((Object)layoutData);
        return section;
    }

    public static Section createTableWrapDataSection(FormToolkit toolkit, Composite parent, int sectionStyle, String title, String description, int marginWidth, int marginHeight, int align, int valign, int rowspan, int colspan) {
        Section section = toolkit.createSection(parent, sectionStyle);
        section.setText(title);
        section.setDescription(description);
        section.marginWidth = marginWidth;
        section.marginHeight = marginHeight;
        toolkit.createCompositeSeparator((Composite)section);
        TableWrapData layoutData = new TableWrapData(align, valign, rowspan, colspan);
        layoutData.grabHorizontal = true;
        layoutData.grabVertical = true;
        section.setLayoutData((Object)layoutData);
        return section;
    }

    public static Label createLabelAndLabel(FormToolkit toolkit, Composite parent, String labelText, String textText, int textWidthHint, int textHeightHint) {
        Label label = toolkit.createLabel(parent, labelText);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Label text = toolkit.createLabel(parent, textText);
        FormSection.fillIntoGridOrTableLayout(parent, label, (Control)text, textWidthHint, textHeightHint);
        return text;
    }

    public static Text createLabelAndText(FormToolkit toolkit, Composite parent, String labelText, String textText, int style, int textWidthHint, int textHeightHint) {
        Label label = toolkit.createLabel(parent, labelText);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = toolkit.createText(parent, textText, style);
        FormSection.fillIntoGridOrTableLayout(parent, label, (Control)text, textWidthHint, textHeightHint);
        return text;
    }

    public static Text createLabelAndText(FormToolkit toolkit, Composite parent, Label label, String textText, int style, int textWidthHint, int textHeightHint) {
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = toolkit.createText(parent, textText, style);
        FormSection.fillIntoGridOrTableLayout(parent, label, (Control)text, textWidthHint, textHeightHint);
        return text;
    }

    public static CCombo createLabelAndCCombo(FormToolkit toolkit, Composite parent, String labelText, int style) {
        Label label = toolkit.createLabel(parent, labelText);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        CCombo ccombo = new CCombo(parent, style);
        toolkit.adapt((Composite)ccombo);
        FormSection.fillIntoGridOrTableLayout(parent, label, (Control)ccombo, 10, 0);
        return ccombo;
    }

    public static void fillIntoGridLayout(Composite parent, Label label, Control control, int widthHint, int heightHint) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            int span = ((GridLayout)layout).numColumns;
            int tspan = span - 1;
            GridData gd = new GridData();
            gd.verticalAlignment = control != null && (control.getStyle() & 2) > 0 ? 1 : 0x1000000;
            if (control == null) {
                gd.horizontalSpan = tspan;
            }
            label.setLayoutData((Object)gd);
            if (control != null) {
                gd = new GridData(256);
                gd.horizontalSpan = tspan;
                gd.grabExcessHorizontalSpace = tspan == 1;
                gd.widthHint = widthHint;
                if (control != null && (control.getStyle() & 2) > 0) {
                    gd.heightHint = heightHint;
                }
                control.setLayoutData((Object)gd);
            }
        }
    }

    public static void fillIntoTableLayout(Composite parent, Label label, Control control, int heightHint) {
        Layout layout = parent.getLayout();
        if (layout instanceof TableWrapLayout) {
            int span = ((TableWrapLayout)layout).numColumns;
            int tspan = span - 1;
            TableWrapData td = new TableWrapData();
            td.valign = 16;
            if (control == null) {
                td.colspan = tspan;
            }
            label.setLayoutData((Object)td);
            if (control != null) {
                td = new TableWrapData(128);
                td.colspan = tspan;
                boolean bl = td.grabHorizontal = tspan == 1;
                if (heightHint > 0) {
                    td.heightHint = heightHint;
                }
                control.setLayoutData((Object)td);
            }
        }
    }

    public static void fillIntoGridOrTableLayout(Composite parent, Label label, Control control, int widthHint, int heightHint) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            FormSection.fillIntoGridLayout(parent, label, control, widthHint, heightHint);
        } else if (layout instanceof TableWrapLayout) {
            FormSection.fillIntoTableLayout(parent, label, control, heightHint);
        }
    }

    public static Composite createColumnLayoutContainer(FormToolkit toolkit, Composite parent, int minNumColumns, int maxNumColumns) {
        Composite container = toolkit.createComposite(parent, 64);
        ColumnLayout layout = new ColumnLayout();
        layout.minNumColumns = minNumColumns;
        layout.maxNumColumns = maxNumColumns;
        container.setLayout((Layout)layout);
        return container;
    }

    public static Composite createGridLayoutContainer(FormToolkit toolkit, Composite parent, int numColumns, int marginWidth, int marginHeight) {
        Composite container = toolkit.createComposite(parent, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        container.setLayout((Layout)layout);
        return container;
    }

    public static ScrolledComposite createGridLayoutScrolledContainer(FormToolkit toolkit, Composite parent, int numColumns, int marginWidth, int marginHeight) {
        ScrolledComposite container = new ScrolledComposite(parent, 832);
        toolkit.adapt((Composite)container);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        container.setLayout((Layout)layout);
        return container;
    }

    public static Composite createTableLayoutContainer(FormToolkit toolkit, Composite parent, int numColumns, boolean makeColumnsEqualWidth, int topMargin, int bottomMargin, int leftMargin, int rightMargin) {
        Composite container = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.topMargin = topMargin;
        layout.bottomMargin = bottomMargin;
        layout.leftMargin = leftMargin;
        layout.rightMargin = rightMargin;
        container.setLayout((Layout)layout);
        return container;
    }

    public static ScrolledComposite createTableLayoutScrolledContainer(FormToolkit toolkit, Composite parent, int numColumns, boolean makeColumnsEqualWidth, int topMargin, int bottomMargin, int leftMargin, int rightMargin) {
        ScrolledComposite container = new ScrolledComposite(parent, 576);
        toolkit.adapt((Composite)container);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.topMargin = topMargin;
        layout.bottomMargin = bottomMargin;
        layout.leftMargin = leftMargin;
        layout.rightMargin = rightMargin;
        container.setLayout((Layout)layout);
        return container;
    }

    public static class LabelAndObject {
        public Label label;
        public Object object;
    }
}

