/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cpe.model;

import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.application.metadata.UimaApplication;
import org.apache.uima.application.metadata.impl.AbstractUimaCasProcessor;
import org.apache.uima.application.metadata.impl.UimaApplication_Impl;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer;
import org.apache.uima.cpe.model.ConfigParametersModel;
import org.apache.uima.cpe.model.CpeDescriptorModel;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class UimaCasInitializer
extends AbstractUimaCasProcessor {
    private CpeCollectionReaderCasInitializer cpeCasInitializer = null;
    private ResourceSpecifier specifier;

    public UimaCasInitializer() {
        super(5, null);
    }

    public UimaCasInitializer(UimaApplication app) {
        super(5, app);
    }

    public UimaCasInitializer(CpeDescriptorModel parentModel, CpeCollectionReaderCasInitializer cpeCasInitializer, UimaApplication app) {
        super(5, app);
        this.cpeCasInitializer = cpeCasInitializer;
        this.xmlDescriptor = cpeCasInitializer.getDescriptor().getInclude().get();
        try {
            this.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(this.xmlDescriptor));
            if (this.specifier instanceof CasInitializerDescription) {
                ProcessingResourceMetaData m = ((CasInitializerDescription)this.specifier).getCasInitializerMetaData();
                this.configParamDecls = m.getConfigurationParameterDeclarations();
                this.configParamSettings = m.getConfigurationParameterSettings();
                this.configParamsModel = new ConfigParametersModel(this.configParamDecls, this.configParamSettings);
                this.setName(m.getName());
                this.setDescription(m.getDescription());
            } else {
                this.specifier = null;
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static UimaCasInitializer createUimaCasProcessor(CpeCollectionReaderCasInitializer cpeCasInitializer, String xmlDescriptor, UimaApplication app) {
        UimaCasInitializer u = new UimaCasInitializer(app);
        u.xmlDescriptor = xmlDescriptor;
        u.instanceName = "Unknown";
        try {
            String resolvedFileName = UimaApplication_Impl.resolveUimaXmlDescriptor(xmlDescriptor);
            u.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(resolvedFileName));
            if (u.specifier instanceof CasInitializerDescription) {
                ProcessingResourceMetaData m = ((CasInitializerDescription)u.specifier).getCasInitializerMetaData();
                u.configParamDecls = m.getConfigurationParameterDeclarations();
                u.configParamSettings = m.getConfigurationParameterSettings();
                u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings);
                u.instanceName = m.getName();
                u.casProcessorDescription = m.getDescription();
                u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, cpeCasInitializer.getConfigurationParameterSettings());
            } else {
                Trace.err("Cannot parse CI xml: " + xmlDescriptor);
                u.specifier = null;
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        return u;
    }

    public static UimaCasInitializer createUimaCasProcessor(CasInitializerDescription casInitializerDescription, String xmlDescriptor, UimaApplication app) {
        UimaCasInitializer u = new UimaCasInitializer(app);
        u.xmlDescriptor = xmlDescriptor;
        u.instanceName = "Unknown";
        try {
            u.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(UimaApplication_Impl.resolveUimaXmlDescriptor(xmlDescriptor)));
            if (u.specifier instanceof CasInitializerDescription) {
                ProcessingResourceMetaData m = ((CasInitializerDescription)u.specifier).getCasInitializerMetaData();
                u.configParamDecls = m.getConfigurationParameterDeclarations();
                u.configParamSettings = m.getConfigurationParameterSettings();
                u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings);
                u.instanceName = m.getName();
                u.casProcessorDescription = m.getDescription();
            } else {
                u.specifier = null;
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        return u;
    }

    public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
        return this.configParamDecls;
    }

    public ConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.configParamSettings;
    }
}

