/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.ui.SelectTypesDialog;
import org.apache.uima.ruta.textruler.ui.TextRulerViewComposite;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class AddRemoveList
extends Composite {
    private boolean error = false;
    private String name;
    private CheckboxTableViewer listViewer;
    private Button add;
    private Button remove;
    private Button up;
    private Button down;
    private Button ts;
    private TextRulerViewComposite parent;
    protected final HashMap<String, Image> images;
    private ArrayList<String> types;
    private boolean ordered;

    public AddRemoveList(String name, HashMap<String, Image> images, TextRulerViewComposite parent, boolean ordered) {
        super((Composite)parent, 0);
        this.name = name;
        this.images = images;
        this.parent = parent;
        this.ordered = ordered;
        this.init();
    }

    private void setTypes() {
        this.error = false;
        this.types.clear();
        String preFilePath = TextRulerViewComposite.getScriptPath();
        File preFile = new File(preFilePath);
        if (!preFile.exists() || StringUtils.isEmpty((CharSequence)preFilePath)) {
            AddRemoveList.printErrorDialog("The preprocessing file was not found!");
            this.error = true;
            return;
        }
        Path scriptPath = new Path(preFilePath);
        String defaultTypeSystemDescriptorLocation = null;
        try {
            defaultTypeSystemDescriptorLocation = RutaProjectUtils.getTypeSystemDescriptorPath((String)scriptPath.toPortableString()).toPortableString();
        }
        catch (CoreException e) {
            TextRulerPlugin.error(e);
        }
        TypeSystemDescription defaultTypeSystemDescription = null;
        try {
            TypeDescription[] systemTypes;
            defaultTypeSystemDescription = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(new File(defaultTypeSystemDescriptorLocation)));
            defaultTypeSystemDescription.resolveImports();
            for (TypeDescription typeDescription : systemTypes = defaultTypeSystemDescription.getTypes()) {
                this.types.add(typeDescription.getName());
            }
            Collections.sort(this.types);
        }
        catch (InvalidXMLException e) {
            TextRulerPlugin.error(e);
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
        }
    }

    public static void printErrorDialog(String error) {
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"File not Found!", (String)error, (IStatus)new Status(4, "-1", "File not found!"));
    }

    private void init() {
        this.setLayout((Layout)new FormLayout());
        this.setSize(200, 300);
        this.types = new ArrayList();
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2818);
        FormData listViewerLData = new FormData();
        listViewerLData.width = 160;
        listViewerLData.height = 150;
        listViewerLData.left = new FormAttachment(0, 1000, 0);
        listViewerLData.right = new FormAttachment(1000, 1000, -40);
        listViewerLData.top = new FormAttachment(0, 1000, 0);
        listViewerLData.bottom = new FormAttachment(1000, 1000, -10);
        this.listViewer.getControl().setLayoutData((Object)listViewerLData);
        this.listViewer.setContentProvider((IContentProvider)new TextRulerViewComposite.ListContentProvider(this.parent));
        TextRulerViewComposite textRulerViewComposite = this.parent;
        ((Object)((Object)textRulerViewComposite)).getClass();
        this.listViewer.setLabelProvider((IBaseLabelProvider)new TextRulerViewComposite.DefaultLabelProvider(textRulerViewComposite, this.name));
        this.listViewer.getTable().setVisible(true);
        if (this.name.equals("FilterTypes")) {
            String input = TextRulerToolkit.getStandardFilterSetString();
            this.addAll(input);
        } else {
            this.listViewer.setAllChecked(true);
        }
        this.listViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int keyCode = e.keyCode;
                if (keyCode == 8 || keyCode == 127) {
                    String[] types;
                    String selected = AddRemoveList.this.listViewer.getSelection().toString();
                    selected = selected.substring(1, selected.length() - 1);
                    for (String string : types = selected.split(", ")) {
                        AddRemoveList.this.listViewer.remove((Object)string);
                    }
                }
            }
        });
        this.ts = new Button((Composite)this, 0x1000008);
        FormData tsLData = new FormData();
        tsLData.width = 25;
        tsLData.height = 25;
        tsLData.top = new FormAttachment(0, 1000, 0);
        tsLData.right = new FormAttachment(1000, 1000, -10);
        this.ts.setLayoutData((Object)tsLData);
        Image tsIcon = this.images.get("prepFolder");
        this.ts.setImage(tsIcon);
        this.ts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fd = new FileDialog(AddRemoveList.this.getShell(), 4096);
                fd.setText("Choose Type System Descriptor");
                String[] filterExt = new String[]{"*.xml", "*.*"};
                fd.setFilterExtensions(filterExt);
                fd.setFileName(AddRemoveList.this.parent.getPreprocessorTMFile());
                String file = fd.open();
                if (file != null) {
                    XMLizable descriptor = null;
                    try {
                        descriptor = UIMAFramework.getXMLParser().parse(new XMLInputSource(file));
                    }
                    catch (InvalidXMLException invalidXMLException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (descriptor instanceof TypeSystemDescription) {
                        TypeDescription[] typeDescs;
                        TypeSystemDescription tsd = (TypeSystemDescription)descriptor;
                        try {
                            tsd.resolveImports();
                        }
                        catch (InvalidXMLException invalidXMLException) {
                            // empty catch block
                        }
                        ArrayList<String> tsTypes = new ArrayList<String>();
                        for (TypeDescription typeDescription : typeDescs = tsd.getTypes()) {
                            String n = typeDescription.getName();
                            tsTypes.add(n);
                        }
                        AddRemoveList.this.addAll(tsTypes);
                    }
                }
            }
        });
        this.add = new Button((Composite)this, 0x1000008);
        FormData addLData = new FormData();
        addLData.width = 25;
        addLData.height = 25;
        addLData.top = new FormAttachment(0, 1000, 27);
        addLData.right = new FormAttachment(1000, 1000, -10);
        this.add.setLayoutData((Object)addLData);
        Image addIcon = this.images.get("add");
        this.add.setImage(addIcon);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddRemoveList.this.setTypes();
                if (AddRemoveList.this.error) {
                    return;
                }
                Display display = Display.getDefault();
                Shell shell = new Shell(display, 67696);
                if (AddRemoveList.this.name.equals("FilterTypes")) {
                    shell.setText("Filter Types");
                } else {
                    shell.setText("Slot Types");
                }
                new SelectTypesDialog(shell, AddRemoveList.this.types, AddRemoveList.this);
            }
        });
        this.remove = new Button((Composite)this, 0x1000008);
        FormData removeLData = new FormData();
        removeLData.width = 25;
        removeLData.height = 25;
        removeLData.top = new FormAttachment(0, 1000, 54);
        removeLData.right = new FormAttachment(1000, 1000, -10);
        this.remove.setLayoutData((Object)removeLData);
        Image deleteIcon = this.images.get("delete");
        this.remove.setImage(deleteIcon);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String[] types;
                String selected = AddRemoveList.this.listViewer.getSelection().toString();
                selected = selected.substring(1, selected.length() - 1);
                for (String string : types = selected.split(", ")) {
                    AddRemoveList.this.listViewer.remove((Object)string);
                }
            }
        });
        if (this.ordered) {
            this.up = new Button((Composite)this, 0x1000008);
            FormData upLData = new FormData();
            upLData.width = 25;
            upLData.height = 25;
            upLData.top = new FormAttachment(0, 1000, 81);
            upLData.right = new FormAttachment(1000, 1000, -10);
            this.up.setLayoutData((Object)upLData);
            Image upIcon = this.images.get("up");
            this.up.setImage(upIcon);
            this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ISelection selection = AddRemoveList.this.listViewer.getSelection();
                    ArrayList<String> dataList = new ArrayList<String>();
                    if (selection instanceof StructuredSelection) {
                        StructuredSelection ss = (StructuredSelection)selection;
                        for (Object object : ss) {
                            TableItem[] items;
                            if (!(object instanceof String)) continue;
                            String obj = (String)object;
                            dataList = new ArrayList();
                            for (TableItem tableItem : items = AddRemoveList.this.listViewer.getTable().getItems()) {
                                dataList.add((String)tableItem.getData());
                            }
                            int indexOf = dataList.indexOf(obj);
                            Collections.swap(dataList, indexOf, indexOf - 1);
                        }
                    }
                    AddRemoveList.this.listViewer.remove(dataList.toArray());
                    AddRemoveList.this.addAll(dataList);
                }
            });
            this.down = new Button((Composite)this, 0x1000008);
            FormData downLData = new FormData();
            downLData.width = 25;
            downLData.height = 25;
            downLData.top = new FormAttachment(0, 1000, 108);
            downLData.right = new FormAttachment(1000, 1000, -10);
            this.down.setLayoutData((Object)downLData);
            Image downIcon = this.images.get("down");
            this.down.setImage(downIcon);
            this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ISelection selection = AddRemoveList.this.listViewer.getSelection();
                    ArrayList<String> dataList = new ArrayList<String>();
                    if (selection instanceof StructuredSelection) {
                        StructuredSelection ss = (StructuredSelection)selection;
                        for (Object object : ss) {
                            TableItem[] items;
                            if (!(object instanceof String)) continue;
                            String obj = (String)object;
                            dataList = new ArrayList();
                            for (TableItem tableItem : items = AddRemoveList.this.listViewer.getTable().getItems()) {
                                dataList.add((String)tableItem.getData());
                            }
                            int indexOf = dataList.indexOf(obj);
                            Collections.swap(dataList, indexOf, indexOf + 1);
                        }
                    }
                    AddRemoveList.this.listViewer.remove(dataList.toArray());
                    AddRemoveList.this.addAll(dataList);
                }
            });
        }
    }

    public String[] getAll() {
        Object[] objectElements;
        ArrayList<String> elements = new ArrayList<String>();
        for (Object object : objectElements = this.listViewer.getCheckedElements()) {
            elements.add(object.toString());
        }
        return elements.toArray(new String[objectElements.length]);
    }

    public String getAllElementsAsString() {
        String result = "";
        this.listViewer.setAllChecked(true);
        for (int i = 0; i < this.listViewer.getCheckedElements().length; ++i) {
            result = i == this.listViewer.getCheckedElements().length - 1 ? result + this.listViewer.getCheckedElements()[i] : result + this.listViewer.getCheckedElements()[i] + ", ";
        }
        return result;
    }

    public void addAll(String input) {
        if (input == null) {
            return;
        }
        int index = 0;
        while (index != -1) {
            String filter;
            index = input.indexOf(",");
            if (index == -1) {
                filter = input;
            } else {
                filter = input.substring(0, index);
                input = input.substring(index + 2);
            }
            boolean isAlreadyAdded = false;
            int i = 0;
            while (this.listViewer.getElementAt(i) != null) {
                if (filter.equals(this.listViewer.getElementAt(i))) {
                    isAlreadyAdded = true;
                    break;
                }
                ++i;
            }
            if (isAlreadyAdded || StringUtils.isBlank((CharSequence)filter)) continue;
            this.listViewer.add((Object)filter);
        }
        this.listViewer.setAllChecked(true);
    }

    public void addAll(List<String> input) {
        this.addAll(input, true);
    }

    public void addAll(List<String> input, boolean checkAll) {
        for (String string : input) {
            boolean isAlreadyAdded = false;
            int i = 0;
            while (this.listViewer.getElementAt(i) != null) {
                if (string.equals(this.listViewer.getElementAt(i))) {
                    isAlreadyAdded = true;
                    break;
                }
                ++i;
            }
            if (isAlreadyAdded) continue;
            this.listViewer.add((Object)string);
        }
        if (checkAll) {
            this.listViewer.setAllChecked(true);
        }
    }
}

