/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.jmx;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.handler.ContextHandler;

public class DeploymentManagerMBean
extends ObjectMBean {
    private final DeploymentManager _manager;

    public DeploymentManagerMBean(Object managedObject) {
        super(managedObject);
        this._manager = (DeploymentManager)managedObject;
    }

    public Collection<String> getNodes() {
        ArrayList<String> nodes = new ArrayList<String>();
        for (Node node : this._manager.getNodes()) {
            nodes.add(node.getName());
        }
        return nodes;
    }

    public Collection<String> getApps() {
        ArrayList<String> apps = new ArrayList<String>();
        for (App app : this._manager.getApps()) {
            apps.add(app.getOriginId());
        }
        return apps;
    }

    public Collection<String> getApps(String nodeName) {
        ArrayList<String> apps = new ArrayList<String>();
        for (App app : this._manager.getApps(nodeName)) {
            apps.add(app.getOriginId());
        }
        return apps;
    }

    public Collection<ContextHandler> getContexts() throws Exception {
        ArrayList<ContextHandler> apps = new ArrayList<ContextHandler>();
        for (App app : this._manager.getApps()) {
            apps.add(app.getContextHandler());
        }
        return apps;
    }

    public Collection<AppProvider> getAppProviders() {
        return this._manager.getAppProviders();
    }

    public void requestAppGoal(String appId, String nodeName) {
        this._manager.requestAppGoal(appId, nodeName);
    }
}

