/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.tinytree.TinyTree;

public class TinyAttributeCollection
implements AttributeCollection {
    int element;
    TinyTree tree;
    int firstAttribute;

    public TinyAttributeCollection(TinyTree tinyTree, int n) {
        this.tree = tinyTree;
        this.element = n;
        this.firstAttribute = tinyTree.alpha[n];
    }

    public void setLocationProvider(LocationProvider locationProvider) {
    }

    public int getLength() {
        int n;
        for (n = this.firstAttribute; n < this.tree.numberOfAttributes && this.tree.attParent[n] == this.element; ++n) {
        }
        return n - this.firstAttribute;
    }

    public int getNameCode(int n) {
        return this.tree.attCode[this.firstAttribute + n];
    }

    public int getTypeAnnotation(int n) {
        if (this.tree.attTypeCode == null) {
            return 631;
        }
        return this.tree.attTypeCode[this.firstAttribute + n];
    }

    public int getLocationId(int n) {
        return 0;
    }

    public String getSystemId(int n) {
        return this.tree.getSystemId(this.element);
    }

    public int getLineNumber(int n) {
        return -1;
    }

    public int getProperties(int n) {
        return 0;
    }

    public String getPrefix(int n) {
        return this.tree.getNamePool().getPrefix(this.getNameCode(n));
    }

    public String getQName(int n) {
        return this.tree.getNamePool().getDisplayName(this.getNameCode(n));
    }

    public String getLocalName(int n) {
        return this.tree.getNamePool().getLocalName(this.getNameCode(n));
    }

    public String getURI(int n) {
        return this.tree.getNamePool().getURI(this.getNameCode(n));
    }

    public int getIndex(String string, String string2) {
        int n = this.tree.getNamePool().getFingerprint(string, string2);
        return this.getIndexByFingerprint(n);
    }

    public int getIndexByFingerprint(int n) {
        int n2 = this.firstAttribute;
        while (this.tree.attParent[n2] == this.element) {
            if ((this.tree.attCode[n2] & 0xFFFFF) == n) {
                return n2 - this.firstAttribute;
            }
            ++n2;
        }
        return -1;
    }

    public String getValueByFingerprint(int n) {
        return this.getValue(this.getIndexByFingerprint(n));
    }

    public String getValue(String string, String string2) {
        return this.getValue(this.getIndex(string, string2));
    }

    public String getValue(int n) {
        return ((Object)this.tree.attValue[this.firstAttribute + n]).toString();
    }

    public boolean isId(int n) {
        return (this.getTypeAnnotation(n) & 0xFFFFF) == 560 || (this.getNameCode(n) & 0xFFFFF) == 388;
    }

    public boolean isIdref(int n) {
        return (this.getTypeAnnotation(n) & 0xFFFFF) == 561 || (this.getTypeAnnotation(n) & 0xFFFFF) == 562;
    }
}

