/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.MetaCasHelper;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.classloader.ProxyException;
import org.apache.uima.ducc.container.common.classloader.ProxyHelper;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.blacklist.JobProcessBlacklist;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.cas.CasManagerStats;
import org.apache.uima.ducc.container.jd.fsm.wi.ActionHelper;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.fsm.wi.IMetaMetaCas;
import org.apache.uima.ducc.container.jd.fsm.wi.MetaMetaCas;
import org.apache.uima.ducc.container.jd.fsm.wi.WiFsm;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.IOperatingInfo;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.ps.net.iface.IMetaTask;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskRequester;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.ps.net.impl.TransactionHelper;

public class ActionGet
implements IAction {
    private static Logger logger = Logger.getLogger(ActionGet.class, IComponent.Id.JD.name());
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedJobDiscontinued = new ConcurrentHashMap();
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedProcessDiscontinued = new ConcurrentHashMap();
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedExhausted = new ConcurrentHashMap();
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedPremature = new ConcurrentHashMap();
    private String allCasesProcessed = "all CASes processed";
    private String fewerWorkItemsAvailableThanExpected = "fewer work items available than expected";
    private String[] nonfatals = new String[]{"org.apache.uima.ducc.user.jd.JdUserSerializationException:"};

    @Override
    public String getName() {
        return ActionGet.class.getName();
    }

    private boolean isKillWorkItem(Exception e) {
        String text;
        boolean retVal = false;
        if (e != null && (text = e.getMessage()) != null) {
            for (String nonfatal : this.nonfatals) {
                if (!text.contains(nonfatal)) continue;
                retVal = true;
            }
        }
        return retVal;
    }

    private void handleException(IActionData actionData, ProxyException e) throws JobDriverException {
        String location = "handleException";
        logger.error(location, ILogger.null_id, e, new Object[0]);
        if (!this.isKillWorkItem(e)) {
            logger.info(location, ILogger.null_id, "killJob");
            throw new JobDriverException(e);
        }
        logger.info(location, ILogger.null_id, "killWorkItem");
        IMetaTask metaCas = this.getEmptyMetaCas();
        JobDriver jd = JobDriver.getInstance();
        IWorkItemStateKeeper wisk = jd.getWorkItemStateKeeper();
        MetaCasHelper metaCasHelper = new MetaCasHelper(metaCas);
        CasManager cm = jd.getCasManager();
        int seqNo = metaCasHelper.getSystemKey();
        String wiId = metaCas.getUserKey();
        String node = "None";
        String pid = "None";
        String tid = "None";
        wisk.start(seqNo, wiId, node, pid, tid);
        wisk.error(seqNo);
        ActionHelper.killWorkItem(logger, actionData, cm);
        Exception userException = ProxyHelper.getTargetException(e);
        String printableException = ActionHelper.getPrintable(userException);
        ActionHelper.toJdErrLog(Standardize.Label.seqNo.get() + seqNo + " ***** EXCEPTION (JD) *****\n" + printableException);
    }

    private IMetaTask getEmptyMetaCas() throws JobDriverException {
        IMetaTask metaCas = null;
        JobDriver jd = JobDriver.getInstance();
        CasManager cm = jd.getCasManager();
        try {
            metaCas = cm.getEmptyMetaCas();
        }
        catch (ProxyException e) {
            throw new JobDriverException(e);
        }
        return metaCas;
    }

    private synchronized IMetaMetaCas getMetaMetaCas(IActionData actionData) throws JobDriverException {
        MetaMetaCas mmc = new MetaMetaCas();
        JobDriver jd = JobDriver.getInstance();
        CasManager cm = jd.getCasManager();
        mmc.setExhausted(cm.getCasManagerStats().isExhausted());
        mmc.setPremature(cm.getCasManagerStats().isPremature());
        mmc.setKillJob(cm.getCasManagerStats().isKillJob());
        if (!(mmc.isExhausted() || mmc.isPremature() || mmc.isKillJob())) {
            while (true) {
                try {
                    mmc.setMetaCas(cm.getMetaCas());
                    mmc.setExhausted(cm.getCasManagerStats().isExhausted());
                    mmc.setPremature(cm.getCasManagerStats().isPremature());
                    mmc.setKillJob(cm.getCasManagerStats().isKillJob());
                }
                catch (ProxyException e) {
                    this.handleException(actionData, e);
                    continue;
                }
                break;
            }
        }
        return mmc;
    }

    private synchronized void ungetMetaMetaCas(IActionData actionData, IRemoteWorkerProcess rwp, IMetaMetaCas mmc, CasManagerStats.RetryReason rr) throws JobDriverException {
        IMetaTask metaCas;
        String location = "ungetMetaMetaCas";
        JobDriver jd = JobDriver.getInstance();
        CasManager cm = jd.getCasManager();
        if (mmc != null && (metaCas = mmc.getMetaCas()) != null) {
            String wiId = metaCas.getUserKey();
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append(Standardize.Label.node.get() + rwp.getNodeName());
            mb.append(Standardize.Label.pid.get() + rwp.getPid());
            mb.append((Object)((Object)Standardize.Label.userKey) + wiId);
            logger.warn(location, ILogger.null_id, mb.toString());
            mmc.setMetaCas(null);
            cm.putMetaCas(metaCas, rr);
        }
    }

    @Override
    public void engage(Object objectData) {
        String location = "engage";
        logger.trace(location, ILogger.null_id, "enter");
        IActionData actionData = (IActionData)objectData;
        try {
            if (actionData != null) {
                MessageBuffer mb;
                Long time;
                IRemoteWorkerThread rwt = actionData.getRemoteWorkerThread();
                WiTracker tracker = WiTracker.getInstance();
                IWorkItem wi = tracker.find(rwt);
                IFsm fsm = wi.getFsm();
                IMetaTaskTransaction trans = actionData.getMetaCasTransaction();
                RemoteWorkerProcess rwp = new RemoteWorkerProcess((IMetaTaskRequester)trans);
                JobDriver jd = JobDriver.getInstance();
                JobDriverHelper jdh = JobDriverHelper.getInstance();
                jd.advanceJdState(IMetaTaskTransaction.JdState.Active);
                IMetaTask metaCas = null;
                JobProcessBlacklist jobProcessBlacklist = JobProcessBlacklist.getInstance();
                IMetaMetaCas mmc = this.getMetaMetaCas(actionData);
                if (mmc.isExhausted()) {
                    time = this.warnedExhausted.putIfAbsent(rwp, new Long(System.currentTimeMillis()));
                    if (time == null) {
                        MessageBuffer mbx = LoggerHelper.getMessageBuffer(actionData);
                        mbx.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mbx.append(Standardize.Label.pid.get() + rwp.getPid());
                        mbx.append(Standardize.Label.text.get() + this.allCasesProcessed);
                        logger.debug(location, ILogger.null_id, mbx.toString());
                    }
                    TransactionHelper.addResponseHint((IMetaTaskTransaction)trans, (IMetaTaskTransaction.Hint)IMetaTaskTransaction.Hint.Exhausted);
                }
                if (mmc.isPremature()) {
                    time = this.warnedPremature.putIfAbsent(rwp, new Long(System.currentTimeMillis()));
                    if (time == null) {
                        String text = this.fewerWorkItemsAvailableThanExpected;
                        jd.killJob(IOperatingInfo.CompletionType.Exception, text);
                        MessageBuffer mbx = LoggerHelper.getMessageBuffer(actionData);
                        mbx.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mbx.append(Standardize.Label.pid.get() + rwp.getPid());
                        mbx.append(Standardize.Label.text.get() + text);
                        logger.debug(location, ILogger.null_id, mbx.toString());
                    }
                    TransactionHelper.addResponseHint((IMetaTaskTransaction)trans, (IMetaTaskTransaction.Hint)IMetaTaskTransaction.Hint.Premature);
                } else if (mmc.isKillJob()) {
                    time = this.warnedJobDiscontinued.putIfAbsent(rwp, new Long(System.currentTimeMillis()));
                    if (time == null) {
                        mb = LoggerHelper.getMessageBuffer(actionData);
                        mb.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mb.append(Standardize.Label.pid.get() + rwp.getPid());
                        mb.append(Standardize.Label.text.get() + "job discontinued");
                        logger.warn(location, ILogger.null_id, mb.toString());
                    }
                    TransactionHelper.addResponseHint((IMetaTaskTransaction)trans, (IMetaTaskTransaction.Hint)IMetaTaskTransaction.Hint.Killed);
                    this.ungetMetaMetaCas(actionData, rwp, mmc, CasManagerStats.RetryReason.ProcessVolunteered);
                } else if (jobProcessBlacklist.includes(rwp)) {
                    time = this.warnedProcessDiscontinued.put(rwp, new Long(System.currentTimeMillis()));
                    if (time == null) {
                        mb = LoggerHelper.getMessageBuffer(actionData);
                        mb.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mb.append(Standardize.Label.pid.get() + rwp.getPid());
                        mb.append(Standardize.Label.text.get() + "process discontinued");
                        logger.warn(location, ILogger.null_id, mb.toString());
                    }
                    TransactionHelper.addResponseHint((IMetaTaskTransaction)trans, (IMetaTaskTransaction.Hint)IMetaTaskTransaction.Hint.Blacklisted);
                    this.ungetMetaMetaCas(actionData, rwp, mmc, CasManagerStats.RetryReason.ProcessDown);
                } else {
                    metaCas = mmc.getMetaCas();
                }
                wi.setMetaCas(metaCas);
                trans.setMetaTask(metaCas);
                IWorkItemStateKeeper wisk = jd.getWorkItemStateKeeper();
                MetaCasHelper metaCasHelper = new MetaCasHelper(metaCas);
                IProcessStatistics pStats = jdh.getProcessStatistics(rwp);
                IEvent event = null;
                if (metaCas != null) {
                    int seqNo = metaCasHelper.getSystemKey();
                    String wiId = metaCas.getUserKey();
                    String node = rwt.getNodeAddress();
                    String pid = "" + rwt.getPid();
                    String tid = "" + rwt.getTid();
                    wisk.start(seqNo, wiId, node, pid, tid);
                    wisk.queued(seqNo);
                    pStats.dispatch(wi);
                    wi.setTodGet();
                    event = WiFsm.CAS_Available;
                    MessageBuffer mb2 = LoggerHelper.getMessageBuffer(actionData);
                    JobDriver.getInstance().getMessageHandler().incGets();
                    logger.info(location, ILogger.null_id, mb2.toString());
                } else {
                    Long time2;
                    event = WiFsm.CAS_Unavailable;
                    MessageBuffer mb3 = LoggerHelper.getMessageBuffer(actionData);
                    mb3.append("No CAS found for processing");
                    logger.debug(location, ILogger.null_id, mb3.toString());
                    if (mmc.isExhausted()) {
                        time2 = this.warnedExhausted.put(rwp, new Long(System.currentTimeMillis()));
                        if (time2 == null) {
                            MessageBuffer mbx = LoggerHelper.getMessageBuffer(actionData);
                            mbx.append(Standardize.Label.node.get() + rwp.getNodeName());
                            mbx.append(Standardize.Label.pid.get() + rwp.getPid());
                            mbx.append(Standardize.Label.text.get() + this.allCasesProcessed);
                            logger.warn(location, ILogger.null_id, mbx.toString());
                        }
                        TransactionHelper.addResponseHint((IMetaTaskTransaction)trans, (IMetaTaskTransaction.Hint)IMetaTaskTransaction.Hint.Exhausted);
                    }
                    if (mmc.isPremature()) {
                        time2 = this.warnedPremature.put(rwp, new Long(System.currentTimeMillis()));
                        if (time2 == null) {
                            String text = this.fewerWorkItemsAvailableThanExpected;
                            jd.killJob(IOperatingInfo.CompletionType.Exception, text);
                            MessageBuffer mbx = LoggerHelper.getMessageBuffer(actionData);
                            mbx.append(Standardize.Label.node.get() + rwp.getNodeName());
                            mbx.append(Standardize.Label.pid.get() + rwp.getPid());
                            mbx.append(Standardize.Label.text.get() + text);
                            logger.debug(location, ILogger.null_id, mbx.toString());
                        }
                        TransactionHelper.addResponseHint((IMetaTaskTransaction)trans, (IMetaTaskTransaction.Hint)IMetaTaskTransaction.Hint.Premature);
                    }
                }
                fsm.transition(event, actionData);
            } else {
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append("No action data found for processing");
                logger.warn(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            JobDriver.getInstance().killJob(IOperatingInfo.CompletionType.Exception);
        }
        logger.trace(location, ILogger.null_id, "exit");
    }
}

