/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.timeout.TimeoutManager;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.ps.net.iface.IMetaTask;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;

public class ActionSend
implements IAction {
    private static Logger logger = Logger.getLogger(ActionSend.class, IComponent.Id.JD.name());

    @Override
    public String getName() {
        return ActionSend.class.getName();
    }

    @Override
    public void engage(Object objectData) {
        String location = "engage";
        logger.trace(location, ILogger.null_id, "");
        IActionData actionData = (IActionData)objectData;
        try {
            if (actionData != null) {
                IRemoteWorkerThread rwt = actionData.getRemoteWorkerThread();
                WiTracker tracker = WiTracker.getInstance();
                IWorkItem wi = tracker.assign(rwt);
                IMetaTaskTransaction trans = actionData.getMetaCasTransaction();
                IMetaTask metaCas = trans.getMetaTask();
                wi.setMetaCas(metaCas);
                TimeoutManager toMgr = TimeoutManager.getInstance();
                toMgr.pendingAck(actionData);
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                logger.debug(location, ILogger.null_id, mb.toString());
            } else {
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append("No action data found for processing");
                logger.warn(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }
}

