/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IRunningWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;

public class RunningWorkItemStatistics
implements IRunningWorkItemStatistics {
    private long millisMin = 0L;
    private long millisMax = 0L;
    private long aboveAvgMillis = 0L;
    private long aboveAvgCount = 0L;
    private long todMostRecentStart = 0L;

    public static RunningWorkItemStatistics getCurrent(long mean) {
        long min = Long.MAX_VALUE;
        long max = 0L;
        long todMrs = 0L;
        long mAbove = 0L;
        long cAbove = 0L;
        ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> map = JobDriver.getInstance().getRemoteWorkerThreadMap();
        for (Map.Entry<IRemoteWorkerThread, IWorkItem> entry : map.entrySet()) {
            long tod;
            IWorkItem wi = entry.getValue();
            long time = wi.getMillisOperating();
            if (time > 0L) {
                if (time > max) {
                    max = time;
                }
                if (time < min) {
                    min = time;
                }
            }
            if (time > mean) {
                mAbove += time;
                ++cAbove;
            }
            if ((tod = wi.getTodAck()) <= todMrs) continue;
            todMrs = tod;
        }
        if (min > max) {
            min = max;
        }
        RunningWorkItemStatistics retVal = new RunningWorkItemStatistics(min, max, todMrs, mAbove, cAbove);
        return retVal;
    }

    public RunningWorkItemStatistics(long min, long max, long todMRS, long aaMillis, long aaCount) {
        this.setMillisMin(min);
        this.setMillisMax(max);
        this.setTodMostRecentStart(todMRS);
        this.setAboveAvgMillis(aaMillis);
        this.setAboveAvgCount(aaCount);
    }

    @Override
    public void setMillisMin(long value) {
        this.millisMin = value;
    }

    @Override
    public long getMillisMin() {
        return this.millisMin;
    }

    @Override
    public void setMillisMax(long value) {
        this.millisMax = value;
    }

    @Override
    public long getMillisMax() {
        return this.millisMax;
    }

    @Override
    public void setAboveAvgMillis(long value) {
        this.aboveAvgMillis = value;
    }

    @Override
    public long getAboveAvgMillis() {
        return this.aboveAvgMillis;
    }

    @Override
    public void setAboveAvgCount(long value) {
        this.aboveAvgCount = value;
    }

    @Override
    public long getAboveAvgCount() {
        return this.aboveAvgCount;
    }

    @Override
    public void setTodMostRecentStart(long value) {
        this.todMostRecentStart = value;
    }

    @Override
    public long getTodMostRecentStart() {
        return this.todMostRecentStart;
    }
}

