/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi.perf.files;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.container.jd.wi.perf.files.IPersistenceJobPerformanceIndividual;
import org.apache.uima.ducc.container.jd.wi.perf.files.JobPerformanceIndividualData;

public class JobPerformanceIndividualJsonGz
implements IPersistenceJobPerformanceIndividual {
    public static final String suffix_json_gz = ".json.gz";
    private String filename = null;
    private Gson gson = new Gson();
    public final String encoding = "UTF-8";

    public JobPerformanceIndividualJsonGz(String directory, String wiNo) {
        this.initialize(directory, wiNo);
    }

    @Override
    public void initialize(String directory, String wiNo) {
        String fn = wiNo + suffix_json_gz;
        this.filename = IOHelper.marryDir2File((String)directory, (String)fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(JobPerformanceIndividualData data) throws IOException {
        BufferedWriter writer = null;
        OutputStreamWriter osr = null;
        GZIPOutputStream gos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            String json = this.gson.toJson((Object)data);
            file = new File(this.filename);
            fos = new FileOutputStream(file);
            gos = new GZIPOutputStream(fos);
            osr = new OutputStreamWriter((OutputStream)gos, "UTF-8");
            writer = new BufferedWriter(osr);
            writer.write(json);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize() throws IOException {
        int size = 0;
        BufferedReader reader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        File file = null;
        int rc = 0;
        try {
            file = new File(this.filename);
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, "UTF-8");
            reader = new BufferedReader(isr);
            while (rc >= 0) {
                rc = reader.read();
                ++size;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobPerformanceIndividualData importData() throws IOException, ClassNotFoundException {
        JobPerformanceIndividualData data = new JobPerformanceIndividualData();
        BufferedReader reader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        File file = null;
        char[] cbuf = new char[this.getSize()];
        try {
            file = new File(this.filename);
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, "UTF-8");
            reader = new BufferedReader(isr);
            reader.read(cbuf);
            String json = new String(cbuf);
            Type typeOfMap = new TypeToken<JobPerformanceIndividualData>(){}.getType();
            data = (JobPerformanceIndividualData)this.gson.fromJson(json, typeOfMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return data;
    }

    public JobPerformanceIndividualData importData(String userid) throws IOException, ClassNotFoundException {
        JobPerformanceIndividualData data = new JobPerformanceIndividualData();
        if (userid == null) {
            data = this.importData();
        } else {
            try {
                AlienFile alienFile = new AlienFile(userid, this.filename);
                String json = alienFile.getString();
                Type typeOfMap = new TypeToken<JobPerformanceIndividualData>(){}.getType();
                data = (JobPerformanceIndividualData)this.gson.fromJson(json, typeOfMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return data;
    }
}

