/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.uima.ducc.agent.metrics.collectors.MetricCollector;

public abstract class AbstractMetricCollector
implements MetricCollector {
    private int howManyFields;
    protected int[] metricFieldOffsets;
    protected int[] metricFieldLengths;
    protected byte[] metricFileContents = new byte[1024];
    protected RandomAccessFile metricFile;
    private int mField;
    private int fieldOffset;
    private int currentOffset = 0;

    public AbstractMetricCollector(RandomAccessFile metricFile, int howMany, int offset) {
        this.howManyFields = howMany;
        this.fieldOffset = offset;
        this.metricFile = metricFile;
        this.metricFieldOffsets = new int[howMany];
        this.metricFieldLengths = new int[howMany];
    }

    @Override
    public void parseMetricFile() throws IOException {
        this.metricFile.seek(0L);
        this.metricFile.read(this.metricFileContents);
        if (this.fieldOffset > 0) {
            while (this.metricFileContents[this.currentOffset] != 32) {
                ++this.currentOffset;
            }
        }
        int currentFieldIndx = 0;
        while (currentFieldIndx++ < this.howManyFields) {
            this.readNextField();
        }
    }

    private void readNextField() {
        while (this.metricFileContents[this.currentOffset] == 32) {
            ++this.currentOffset;
        }
        int offset = this.currentOffset;
        while (this.metricFileContents[this.currentOffset] != 32 && this.metricFileContents[this.currentOffset] != 0) {
            ++this.currentOffset;
        }
        this.metricFieldOffsets[this.mField] = offset;
        this.metricFieldLengths[this.mField++] = this.currentOffset - offset;
        this.currentOffset += this.fieldOffset;
    }
}

