/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.dgen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.ps.service.ServiceConfiguration;
import org.apache.uima.ducc.ps.service.dgen.DeployableGenerator;
import org.apache.uima.ducc.ps.service.dgen.DuccUimaAggregate;
import org.apache.uima.ducc.ps.service.dgen.DuccUimaAggregateComponent;
import org.apache.uima.ducc.ps.service.dgen.DuccUimaReferenceByName;
import org.apache.uima.ducc.ps.service.dgen.iface.IDeployableGeneration;
import org.apache.uima.ducc.ps.service.dgen.iface.IDuccGeneratorUimaAggregateComponent;
import org.apache.uima.ducc.ps.service.utils.Utils;

public class DeployableGeneration
implements IDeployableGeneration {
    private ServiceConfiguration serviceConfiguration;

    public DeployableGeneration(ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    private void conditionalAddComponent(ArrayList<IDuccGeneratorUimaAggregateComponent> dgenComponents, String descriptor, List<String> overrides) {
        if (descriptor != null) {
            DuccUimaAggregateComponent dgenComponent = new DuccUimaAggregateComponent(descriptor, overrides);
            dgenComponents.add(dgenComponent);
        }
    }

    private void show(String text) {
        System.out.println(text);
    }

    private void show(String name, String value) {
        this.show(name + "=" + value);
    }

    private void show(String name, List<String> value) {
        if (value == null) {
            this.show(name + "=" + value);
        } else {
            this.show(name + "=" + value.toString());
        }
    }

    private String fabricateTargetDirectoryName(String baseDir, String jobId) {
        StringBuffer sb = new StringBuffer();
        if (baseDir != null) {
            sb.append(baseDir);
            if (!baseDir.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            if (jobId != null) {
                sb.append(jobId);
            }
        }
        return sb.toString();
    }

    @Override
    public String generate(Boolean createUniqueFilename) throws Exception {
        String retVal = null;
        try {
            this.show("directory", this.serviceConfiguration.getJobDirectory());
            this.show("id", this.serviceConfiguration.getJobId());
            this.show("dgenThreadCount", this.serviceConfiguration.getThreadCount());
            this.show("dgenFlowController", this.serviceConfiguration.getJpFlowController());
            this.show("cmDescriptor", this.serviceConfiguration.getCmDescriptor());
            this.show("cmOverrides", this.serviceConfiguration.getCmOverrides());
            this.show("aeDescriptor", this.serviceConfiguration.getAeDescriptor());
            this.show("aeOverrides", this.serviceConfiguration.getAeOverrides());
            this.show("ccDescriptor", this.serviceConfiguration.getCcDescriptor());
            this.show("ccOverrides", this.serviceConfiguration.getCcOverrides());
            this.show("createUniqueFilename", createUniqueFilename != false ? "true" : "false");
            String targetDirectory = this.fabricateTargetDirectoryName(this.serviceConfiguration.getJobDirectory(), this.serviceConfiguration.getJobId());
            DeployableGenerator deployableGenerator = new DeployableGenerator(targetDirectory);
            ArrayList<IDuccGeneratorUimaAggregateComponent> dgenComponents = new ArrayList<IDuccGeneratorUimaAggregateComponent>();
            ArrayList<String> cmOverrides = Utils.tokenizeList(this.serviceConfiguration.getCmOverrides(), true);
            ArrayList<String> ccOverrides = Utils.tokenizeList(this.serviceConfiguration.getCcOverrides(), true);
            ArrayList<String> aeOverrides = Utils.tokenizeList(this.serviceConfiguration.getAeOverrides(), true);
            this.conditionalAddComponent(dgenComponents, this.serviceConfiguration.getCmDescriptor(), cmOverrides);
            this.conditionalAddComponent(dgenComponents, this.serviceConfiguration.getAeDescriptor(), aeOverrides);
            this.conditionalAddComponent(dgenComponents, this.serviceConfiguration.getCcDescriptor(), ccOverrides);
            DuccUimaAggregate configuration = new DuccUimaAggregate(this.serviceConfiguration, dgenComponents);
            retVal = deployableGenerator.generateAe(configuration, this.serviceConfiguration.getJobId(), createUniqueFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.toString());
        }
        return retVal;
    }

    @Override
    public String generate(String directory, String id, Integer dgenThreadCount, String ddName, Boolean createUniqueFilename) throws Exception {
        String retVal = null;
        try {
            this.show("directory", directory);
            this.show("id", id);
            this.show("dgenThreadCount", dgenThreadCount.toString());
            this.show("ddName", ddName);
            this.show("createUniqueFilename", createUniqueFilename != false ? "true" : "false");
            String targetDirectory = this.fabricateTargetDirectoryName(directory, id);
            DeployableGenerator deployableGenerator = new DeployableGenerator(targetDirectory);
            DuccUimaReferenceByName configuration = new DuccUimaReferenceByName(dgenThreadCount, ddName);
            retVal = deployableGenerator.generateDd(configuration, id, createUniqueFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.toString());
        }
        return retVal;
    }
}

