/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.main;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.ps.ServiceThreadFactory;
import org.apache.uima.ducc.ps.service.IService;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.errors.ServiceException;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.ducc.ps.service.main.Application;
import org.apache.uima.ducc.ps.service.monitor.IServiceMonitor;
import org.apache.uima.ducc.ps.service.processor.IServiceProcessor;
import org.apache.uima.ducc.ps.service.protocol.IServiceProtocolHandler;
import org.apache.uima.ducc.ps.service.protocol.builtin.DefaultNoTaskAvailableStrategy;
import org.apache.uima.ducc.ps.service.protocol.builtin.DefaultServiceProtocolHandler;
import org.apache.uima.ducc.ps.service.registry.DefaultRegistryClient;
import org.apache.uima.ducc.ps.service.registry.IRegistryClient;
import org.apache.uima.ducc.ps.service.transport.IServiceTransport;
import org.apache.uima.ducc.ps.service.transport.ITargetURI;
import org.apache.uima.ducc.ps.service.transport.http.HttpServiceTransport;
import org.apache.uima.ducc.ps.service.transport.target.TargetURIFactory;
import org.apache.uima.ducc.ps.service.utils.Utils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class PullService
implements IService {
    Logger logger = UIMAFramework.getLogger(PullService.class);
    private ScheduledThreadPoolExecutor threadPool;
    private int scaleout = 1;
    private int waitTimeInMillis = 1000;
    private String type;
    private volatile boolean initialized = false;
    private String clientURL;
    private IRegistryClient registryClient;
    private IServiceErrorHandler errorHandler = null;
    private IServiceMonitor serviceMonitor = null;
    private IServiceTransport transport = null;
    private IServiceProtocolHandler protocolHandler = null;
    private IServiceProcessor serviceProcessor;
    private CountDownLatch threadsReady;
    private List<Future<String>> threadHandleList = new ArrayList<Future<String>>();
    private Lock initLock = new ReentrantLock();
    private Application application = null;

    public PullService(String type) {
        this(type, null);
    }

    public PullService(String type, Application application) {
        this.type = type;
        this.application = application;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setWaitTime(int waitTimeInMillis) {
        this.waitTimeInMillis = waitTimeInMillis;
    }

    public void setScaleout(int scaleout) {
        this.scaleout = scaleout;
        this.threadsReady = new CountDownLatch(scaleout);
    }

    private void setErrorHandler(IServiceErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void setMonitor(IServiceMonitor monitor) {
        this.serviceMonitor = monitor;
    }

    private void setProtocolHandler(IServiceProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    private void setTransport(IServiceTransport transport) {
        this.transport = transport;
    }

    public void setServiceProcessor(IServiceProcessor serviceProcessor) {
        this.serviceProcessor = serviceProcessor;
    }

    public void setRegistryClient(IRegistryClient registryClient) {
        this.registryClient = registryClient;
    }

    public void setClientURL(String clientURL) {
        this.clientURL = clientURL;
    }

    private void initializeDefaultRegistryClient() throws ServiceInitializationException {
        ITargetURI target;
        if (this.clientURL == null || this.clientURL.isEmpty()) {
            throw new ServiceInitializationException("Application must plugin IRegistryClient instance or provide a valid client URL");
        }
        try {
            target = TargetURIFactory.newTarget(this.clientURL);
        }
        catch (ServiceException e) {
            throw new ServiceInitializationException("Unsupported registry URL " + this.clientURL, e);
        }
        this.registryClient = new DefaultRegistryClient(target);
    }

    @Override
    public void initialize() throws ServiceInitializationException {
        block13: {
            this.initLock.lock();
            try {
                if (this.initialized) {
                    return;
                }
                if (this.registryClient == null) {
                    this.initializeDefaultRegistryClient();
                }
                DefaultNoTaskAvailableStrategy waitStrategy = new DefaultNoTaskAvailableStrategy(this.waitTimeInMillis);
                this.transport = new HttpServiceTransport(this.registryClient, this.scaleout);
                if (this.threadsReady == null) {
                    this.threadsReady = new CountDownLatch(this.scaleout);
                }
                CountDownLatch stopLatch = new CountDownLatch(this.scaleout);
                this.serviceProcessor.setScaleout(this.scaleout);
                this.protocolHandler = new DefaultServiceProtocolHandler.Builder().withProcessor(this.serviceProcessor).withNoTaskStrategy(waitStrategy).withService(this).withTransport(this.transport).withDoneLatch(stopLatch).withInitCompleteLatch(this.threadsReady).build();
                this.threadPool = new ScheduledThreadPoolExecutor(this.scaleout, new ServiceThreadFactory());
                for (int j = 0; j < this.scaleout; ++j) {
                    this.threadHandleList.add(this.threadPool.submit(this.protocolHandler));
                }
                this.threadsReady.await();
                if (this.protocolHandler.initialized()) {
                    this.logger.log(Level.INFO, "Service Initialized ...........");
                    this.initializeMonitor();
                    this.initializeTransport();
                    this.initialized = true;
                    break block13;
                }
                this.logger.log(Level.INFO, "Protocol Handler Failed Initialization ...........");
                throw new ServiceInitializationException("Service Protocol Handler Failed Initialization");
            }
            catch (ServiceInitializationException e) {
                System.out.println(">>>>>>>>>>>>>> ServiceInitializationException in Pullservice.initialize()");
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.threadPool.shutdownNow();
                throw new ServiceInitializationException("Service interrupted during initialization - shutting down process threads");
            }
            catch (Exception e) {
                System.out.println(">>>>>>>>>>>>>> Error in Pullservice.initialize()");
                throw new ServiceInitializationException("", e);
            }
            finally {
                this.initLock.unlock();
            }
        }
    }

    @Override
    public void start() throws ExecutionException, ServiceException {
        if (!this.initialized) {
            throw new IllegalStateException("Application must call initialize() before calling start()");
        }
        try {
            this.protocolHandler.start();
            this.waitForProcessThreads();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (this.threadPool.isTerminating()) {
                return;
            }
            this.threadPool.shutdownNow();
        }
    }

    @Override
    public void stop() {
        this.logger.log(Level.INFO, "Stopping Process Thread Pool");
        this.threadPool.shutdownNow();
        this.stopTransport();
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .quiesceAndStop()-transport stopped");
        this.stopProtocolHandler(false);
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .quiesceAndStop()-protocol handler stopped");
        this.stopServiceProcessor();
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .stop()-processor stopped");
        this.stopMonitor();
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .dtop()-monitor stopped");
    }

    @Override
    public void quiesceAndStop() {
        this.stopProtocolHandler(true);
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .quiesceAndStop()-protocol handler stopped");
        this.stopTransport();
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .quiesceAndStop()-transport stopped");
        this.stopServiceProcessor();
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .quiesceAndStop()-processor stopped");
        this.stopMonitor();
        System.out.println(">>>>>>>> " + Utils.getTimestamp() + " " + Utils.getShortClassname(this.getClass()) + " .quiesceAndStop()-monitor stopped");
    }

    private void waitForProcessThreads() throws InterruptedException, ExecutionException {
        for (Future<String> future : this.threadHandleList) {
            String result = future.get();
            this.logger.log(Level.INFO, "Thread:" + Thread.currentThread().getName() + " Terminated " + new Date() + "::" + result);
        }
        this.stopProcessThreadPool();
        if (Objects.nonNull(this.application)) {
            this.application.onServiceStop();
        }
    }

    private void initializeTransport() throws ServiceInitializationException {
        try {
            this.transport.initialize();
        }
        catch (Exception cause) {
            throw new ServiceInitializationException("Service Unable to Initialize Transport", cause);
        }
    }

    private void initializeMonitor() throws ServiceInitializationException {
        if (this.serviceMonitor != null) {
            try {
                this.serviceMonitor.initialize();
            }
            catch (Exception cause) {
                throw new ServiceInitializationException("Service Unable to Initialize Monitor", cause);
            }
        }
    }

    private void stopProcessThreadPool() {
        if (this.threadPool != null) {
            try {
                this.logger.log(Level.INFO, "Stopping Process Thread Pool");
                this.threadPool.shutdownNow();
                this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                this.logger.log(Level.INFO, "Process Thread Pool Stopped");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void stopMonitor() {
        if (this.serviceMonitor != null) {
            this.serviceMonitor.stop();
        }
    }

    private void stopServiceProcessor() {
        if (this.serviceProcessor != null) {
            this.serviceProcessor.stop();
        }
    }

    private void stopProtocolHandler(boolean quiesce) {
        if (quiesce) {
            this.protocolHandler.quiesceAndStop();
        } else {
            this.protocolHandler.stop();
        }
    }

    private void stopTransport() {
        this.transport.stop(false);
    }

    public static void main(String[] args) {
    }
}

