/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.CommandLine;
import org.apache.uima.ducc.cli.IUiOption;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.sm.SmConstants;

public class ServicePingMain
implements SmConstants {
    boolean debug = false;
    int error_max = 10;
    int error_count = 0;
    CommandLine command_line = null;
    IUiOption[] options = new IUiOption[]{OptionSet.Class, OptionSet.Endpoint, OptionSet.Port, OptionSet.Arguments, OptionSet.Initprops};

    public void usage() {
        System.out.println(this.command_line.formatHelp(this.getClass().getName()));
        System.exit(1);
    }

    void appendStackTrace(StringBuffer s, Throwable t) {
        StackTraceElement[] stacktrace;
        s.append("\nAt:\n");
        for (StackTraceElement ste : stacktrace = t.getStackTrace()) {
            s.append("\t");
            s.append(ste.toString());
            s.append("\n");
        }
    }

    public void print(Object ... args) {
        StringBuffer s = new StringBuffer();
        for (Object a : args) {
            if (a == null) {
                a = "<null>";
            }
            s.append(" ");
            if (a instanceof Throwable) {
                Throwable t = (Throwable)a;
                s.append(t.toString());
                s.append("\n");
                this.appendStackTrace(s, t);
                continue;
            }
            s.append(a.toString());
        }
        System.err.println(s.toString());
    }

    AServicePing resolve(String cl, String args, String ep, Map<String, Object> initprops) {
        this.print("ServicePingMain.resolve:", cl, "ep", ep);
        AServicePing pinger = null;
        try {
            Class<?> cls = Class.forName(cl);
            pinger = (AServicePing)cls.newInstance();
            pinger.init(args, ep, initprops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pinger;
    }

    void handleError(AServicePing custom, Throwable t) {
        t.printStackTrace();
        if (++this.error_count >= this.error_max) {
            custom.stop();
            System.out.println("Exceeded error count. Exiting.");
            System.exit(1);
        }
        System.out.println("ServicePingMain: Error count " + this.error_count + " < threshold of " + this.error_max);
    }

    protected Map<String, Object> stringToProperties(String prop_string) {
        String[] as = prop_string.split(",");
        StringWriter sw = new StringWriter();
        for (String s : as) {
            sw.write(s + "\n");
        }
        StringReader sr = new StringReader(sw.toString());
        DuccProperties props = new DuccProperties();
        try {
            props.load((Reader)sr);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String k = "failure-window";
        int v_int = props.getIntProperty(k);
        ret.put(k, v_int);
        k = "failure-max";
        v_int = props.getIntProperty(k);
        ret.put(k, v_int);
        k = "monitor-rate";
        v_int = props.getIntProperty(k);
        ret.put(k, v_int);
        k = "service-id";
        long v_long = props.getLongProperty(k);
        ret.put(k, v_long);
        k = "do-log";
        boolean v_bool = props.getBooleanProperty(k, false);
        ret.put(k, v_bool);
        k = "autostart-enabled";
        v_bool = props.getBooleanProperty(k, false);
        ret.put(k, v_bool);
        k = "last-use";
        v_long = props.getLongProperty(k, 0L);
        ret.put(k, v_long);
        for (String rk : ret.keySet()) {
            this.print("init:", rk, "=", ret.get(rk));
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    protected int start(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        ServicePingMain wrapper = new ServicePingMain();
        int rc = wrapper.start(args);
        System.exit(rc);
    }

    static enum OptionSet implements IUiOption
    {
        Class{

            public String pname() {
                return "class";
            }

            public String argname() {
                return "Java classname";
            }

            @Override
            public boolean required() {
                return true;
            }

            public String description() {
                return "This is the name of the class implementing the pinger";
            }

            @Override
            public String example() {
                return "org.bob.PingClass";
            }
        }
        ,
        Endpoint{

            public String pname() {
                return "endpoint";
            }

            public String argname() {
                return "string";
            }

            @Override
            public boolean required() {
                return true;
            }

            public String description() {
                return "Thsi is the endpoint specified in teh registration.";
            }

            @Override
            public String example() {
                return "UIMA-AS:MyUimaAsEndpoint:/tcp//broker1:1234";
            }
        }
        ,
        Port{

            public String pname() {
                return "port";
            }

            public String argname() {
                return "integer";
            }

            @Override
            public boolean required() {
                return true;
            }

            public String description() {
                return "This is the port the broker is listening on.";
            }

            @Override
            public String example() {
                return "12345";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Arguments{

            public String pname() {
                return "arguments";
            }

            public String argname() {
                return "string";
            }

            public String description() {
                return "Argument string from pinger registration, if any.";
            }
        }
        ,
        Initprops{

            public String pname() {
                return "initprops";
            }

            public String argname() {
                return "string";
            }

            public String description() {
                return "Initialization properties, if any.";
            }
        };


        public boolean multiargs() {
            return false;
        }

        public boolean required() {
            return false;
        }

        public String deflt() {
            return null;
        }

        public String label() {
            return null;
        }

        public String sname() {
            return null;
        }

        public boolean optargs() {
            return false;
        }

        public boolean noargs() {
            return false;
        }

        public String example() {
            return null;
        }

        public String makeDesc() {
            if (this.example() == null) {
                return this.description();
            }
            return this.description() + "\nexample: " + this.example();
        }
    }
}

