/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class SystemState {
    private static final DuccLogger logger = DuccLogger.getLogger(SystemState.class);
    private static SystemState instance = new SystemState();
    private static String jobsStop = IDuccEnv.DUCC_STATE_DIR + "ducc.jobs.stop";
    private static DuccId jobid = null;

    public static SystemState getInstance() {
        return instance;
    }

    public boolean isAcceptJobs() {
        String location = "isAcceptJobs";
        boolean retVal = true;
        try {
            File file = new File(jobsStop);
            retVal = !file.exists();
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
        return retVal;
    }

    public void resetAcceptJobs(String userid) {
        String location = "resetAcceptJobs";
        try {
            Properties properties = new Properties();
            properties.put("userid", userid);
            String comments = null;
            FileOutputStream fos = null;
            OutputStreamWriter out = null;
            fos = new FileOutputStream(jobsStop);
            out = new OutputStreamWriter(fos);
            properties.store(out, comments);
            out.close();
            fos.close();
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }

    public void setAcceptJobs() {
        String location = "setAcceptJobs";
        try {
            File file = new File(jobsStop);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }
}

