/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils.id;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.IDuccIdFactory;

public class DuccIdFactory
implements IDuccIdFactory {
    private AtomicLong seqno = new AtomicLong(-1L);

    public DuccIdFactory() {
    }

    public DuccIdFactory(long seed) {
        this.seqno.set(seed - 1L);
    }

    public DuccId next(long s) {
        this.seqno.set(Math.max(s, this.seqno.get()));
        return new DuccId(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuccId next() {
        DuccIdFactory duccIdFactory = this;
        synchronized (duccIdFactory) {
            this.seqno.incrementAndGet();
            return new DuccId(this.seqno.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setIfMax(long candidate) {
        long previous = this.seqno.get();
        DuccIdFactory duccIdFactory = this;
        synchronized (duccIdFactory) {
            if (candidate > previous) {
                this.seqno.set(candidate);
            }
        }
        return previous;
    }
}

