/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils.alien;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.uima.ducc.ws.server.AlienTextFile;

public class FileInfo {
    public String reldir = null;
    public String permissions = null;
    public String user = null;
    public String group = null;
    public long length = 0L;
    public String date = null;
    public String time = null;
    public String name = null;
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.ENGLISH);
    private SimpleDateFormat dow = new SimpleDateFormat("E");

    public FileInfo(String reldir, String permissions, String user, String group, long length, String date, String time, String name) {
        this.setRelDir(reldir);
        this.setPermissions(permissions);
        this.setUser(user);
        this.setGroup(group);
        this.setLength(length);
        this.setDate(date);
        this.setTime(time);
        this.setName(name);
    }

    public void setRelDir(String value) {
        this.reldir = value;
    }

    public String getRelDir() {
        return this.reldir;
    }

    public void setPermissions(String value) {
        this.permissions = value;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public boolean isDirectory() {
        boolean retVal = false;
        if (this.permissions != null && this.permissions.startsWith("d")) {
            retVal = true;
        }
        return retVal;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getUser() {
        return this.user;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public long getTOD() {
        long retVal = 0L;
        try {
            String dt = this.getDate() + " " + this.getTime();
            Date date = this.format.parse(dt);
            retVal = date.getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public String getDOW() {
        String retVal = "";
        try {
            String dt = this.getDate() + " " + this.getTime();
            Date date = this.format.parse(dt);
            retVal = this.dow.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public long getLastModified() {
        return this.getTOD();
    }

    public String getGroup() {
        return this.group;
    }

    public void setLength(long value) {
        this.length = value;
    }

    public long getLength() {
        return this.length;
    }

    public int getPageCount() {
        int retVal = 0;
        int pageSize = AlienTextFile.get_page_bytes();
        long fileBytes = this.length;
        retVal = (int)Math.ceil((double)fileBytes / (1.0 * (double)pageSize));
        return retVal;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setTime(String value) {
        this.time = value;
    }

    public String getTime() {
        return this.time;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        String retVal = this.name;
        if (this.name != null) {
            retVal = this.name.substring(this.name.lastIndexOf(File.separator) + 1);
        }
        return retVal;
    }
}

