/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.uima.ducc.common.utils.DuccCollectionUtils;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.JobManagerStateReconciler;

public class DefaultJobManagerStateReconciler
implements JobManagerStateReconciler {
    private JobManagerStateReconciler.WorkChangesHandler jobChangesCallback;
    private JobManagerStateReconciler.WorkProcessChangesHandler processChangesCallback;
    private DuccLogger logger;

    public DefaultJobManagerStateReconciler(DuccLogger logger) {
        this.logger = logger;
    }

    @Override
    public void reconcile(Map<DuccId, IDuccWork> left, Map<DuccId, IDuccWork> right) {
        Preconditions.checkNotNull((Object)this.jobChangesCallback, (Object)"JobChangesHandler Callback not Specified");
        Preconditions.checkNotNull((Object)this.processChangesCallback, (Object)"JobProcessChangesHandler Callback not Specified");
        DuccCollectionUtils.DuccMapDifference jobDifferenceMap = DuccCollectionUtils.difference(left, right);
        try {
            this.jobChangesCallback.onNewWork(jobDifferenceMap.getLeft());
            this.jobChangesCallback.onRemovedWork(jobDifferenceMap.getRight());
            for (DuccCollectionUtils.DuccMapValueDifference jd : jobDifferenceMap) {
                this.jobChangesCallback.onWorkChanges((IDuccWork)jd.getLeft(), (IDuccWork)jd.getRight());
            }
            for (DuccCollectionUtils.DuccMapValueDifference jd : jobDifferenceMap) {
                DuccCollectionUtils.DuccMapDifference processDifference = DuccCollectionUtils.difference(((IDuccWorkExecutable)jd.getLeft()).getProcessMap().getMap(), (Map)((IDuccWorkExecutable)jd.getRight()).getProcessMap());
                if (processDifference.getLeft().size() > 0) {
                    this.processChangesCallback.onNewWorkProcesses((IDuccWork)jd.getLeft(), ((IDuccWorkExecutable)jd.getLeft()).getCommandLine(), processDifference.getLeft(), ((IDuccWorkExecutable)jd.getRight()).getProcessMap().getMap());
                }
                if (processDifference.getRight().size() > 0) {
                    this.processChangesCallback.onRemovedWorkProcesses(((IDuccWork)jd.getLeft()).getDuccId(), processDifference.getRight(), ((IDuccWorkExecutable)jd.getRight()).getProcessMap().getMap());
                }
                for (DuccCollectionUtils.DuccMapValueDifference pd : processDifference) {
                    this.processChangesCallback.onProcessChanges((IDuccWork)jd.getLeft(), (IDuccProcess)pd.getLeft(), (IDuccProcess)pd.getRight());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("DefaultJobManagerStateReconciler.reconcile", null, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setWorkChangesHandler(JobManagerStateReconciler.WorkChangesHandler callback) {
        this.jobChangesCallback = callback;
    }

    @Override
    public void setWorkProcessChanges(JobManagerStateReconciler.WorkProcessChangesHandler callback) {
        this.processChangesCallback = callback;
    }
}

