/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sampleapps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.ducc.sampleapps.DuccDocumentInfo;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class DuccTextCM
extends JCasMultiplier_ImplBase {
    private byte[] buffer = null;
    private int buffsize;
    private FileInputStream fis;
    private String inputFileName;
    private String outputFileName;
    private String language;
    private String encoding;
    private String nextDoc;
    private int nextDocOffset;
    private int bytelength;
    private int blockindex;
    private boolean newWI;
    private boolean spilled;
    private boolean firstdoc;
    private boolean lastblock;
    private int docInWI;
    private long filesize;
    private Workitem wi;
    private int currentindex;
    private Logger logger;
    FileChannel fc;
    private NextDoc strategy;
    private final int DEFAULT_BUFFER_SIZE = 20000000;

    public boolean hasNext() throws AnalysisEngineProcessException {
        if (this.spilled) {
            return false;
        }
        try {
            return this.findnextdoc(this.strategy);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        JCas newcas = this.getEmptyJCas();
        newcas.setDocumentText(this.getNextDocument());
        newcas.setDocumentLanguage(this.language);
        DuccDocumentInfo di = new DuccDocumentInfo(newcas);
        di.setInputfile(this.inputFileName);
        di.setOutputfile(this.outputFileName);
        di.setDocseq(this.docInWI++);
        di.setByteoffset(this.wi.getBlockindex() * this.wi.getBlocksize() + this.nextDocOffset);
        di.addToIndexes();
        return newcas;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        FSIterator fsit = jcas.getIndexRepository().getAllIndexedFS(jcas.getCasType(Workitem.type));
        if (!fsit.hasNext()) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("No workitem FS in CAS"));
        }
        this.wi = (Workitem)fsit.next();
        this.logger.log(Level.INFO, "DuccTextCM: " + this.wi.getInputspec() + " at block " + this.wi.getBlockindex() + " length " + this.wi.getBytelength() + " offset " + this.wi.getBlockindex() * this.wi.getBlocksize() + " outputs " + this.wi.getOutputspec());
        try {
            this.openInputFile(this.wi);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        if (this.buffer == null) {
            if (this.wi.getBlocksize() > 0) {
                this.buffer = new byte[this.wi.getBlocksize() * 2];
                this.buffsize = this.wi.getBlocksize() * 2;
            } else {
                this.buffer = new byte[20000000];
                this.buffsize = 20000000;
            }
        } else if (this.wi.getBytelength() > this.buffsize) {
            this.buffer = new byte[this.wi.getBytelength() * 2];
            this.buffsize = this.wi.getBytelength();
        }
        this.spilled = false;
        this.docInWI = 0;
        this.strategy = this.blockindex == 0 ? NextDoc.FIRSTDOC : NextDoc.NORMAL;
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.logger = aContext.getLogger();
    }

    private void openInputFile(Workitem wi) throws IOException {
        this.inputFileName = wi.getInputspec();
        this.outputFileName = wi.getOutputspec();
        this.bytelength = wi.getBytelength();
        this.blockindex = wi.getBlockindex();
        this.lastblock = wi.getLastBlock();
        this.language = wi.getLanguage();
        this.fis = new FileInputStream(new File(this.inputFileName));
        this.encoding = null == wi.getEncoding() ? "UTF-8" : wi.getEncoding();
        this.fc = this.fis.getChannel();
        long start = wi.getBlockindex() * wi.getBlocksize();
        this.filesize = this.fc.size();
        if (start > this.filesize) {
            throw new IOException("Specifid start position beyond end of input file " + this.inputFileName);
        }
        this.fis.skip(start);
        this.newWI = true;
    }

    private boolean findnextdoc(NextDoc condition) throws IOException {
        int endloc;
        int len;
        int startloc = -1;
        if (this.newWI) {
            this.newWI = false;
            len = this.fis.read(this.buffer, 0, this.bytelength);
            if (len != this.bytelength) {
                throw new IOException("Read " + len + " bytes, expected " + this.bytelength);
            }
            this.currentindex = 0;
        }
        if (condition.equals((Object)NextDoc.SEP_IN_LASTBLOCK)) {
            if (10 == this.buffer[this.currentindex] && 10 == this.buffer[this.currentindex + 1]) {
                return false;
            }
            if (10 == this.buffer[this.currentindex]) {
                ++this.currentindex;
            }
            startloc = this.currentindex;
            endloc = 0;
            while (this.currentindex < this.bytelength - 1) {
                if (10 == this.buffer[this.currentindex] && 10 == this.buffer[this.currentindex + 1]) {
                    endloc = this.currentindex - 1;
                    break;
                }
                ++this.currentindex;
            }
            if (endloc == 0) {
                throw new RuntimeException("Document larger than " + this.bytelength + " found in " + this.inputFileName + " block " + this.blockindex);
            }
            byte[] docbytes = Arrays.copyOfRange(this.buffer, startloc, endloc);
            this.nextDoc = new String(docbytes, this.encoding);
            this.nextDocOffset = startloc;
            return true;
        }
        if (condition.equals((Object)NextDoc.FIRSTDOC)) {
            this.strategy = NextDoc.NORMAL;
            while (10 == this.buffer[this.currentindex]) {
                ++this.currentindex;
                if (this.currentindex != this.bytelength || !this.firstdoc) continue;
                return false;
            }
        }
        if (condition.equals((Object)NextDoc.NORMAL)) {
            if (10 != this.buffer[this.currentindex] || 10 != this.buffer[this.currentindex + 1]) {
                while (this.currentindex < this.bytelength - 1 && (10 != this.buffer[this.currentindex] || 10 != this.buffer[this.currentindex + 1])) {
                    ++this.currentindex;
                }
            }
            if (this.currentindex == this.bytelength - 1) {
                this.fis.close();
                return false;
            }
            while (10 == this.buffer[this.currentindex]) {
                ++this.currentindex;
                if (this.currentindex != this.bytelength) continue;
                if (this.lastblock) {
                    this.fis.close();
                    return false;
                }
                len = this.fis.read(this.buffer, this.bytelength, this.bytelength);
                if (len <= 0) {
                    throw new IOException("Read " + len + " bytes for " + this.inputFileName + " block " + this.blockindex + 1);
                }
                this.fis.close();
                this.spilled = true;
                this.bytelength += len;
                return this.findnextdoc(NextDoc.SEP_IN_LASTBLOCK);
            }
        }
        startloc = this.currentindex;
        endloc = 0;
        while (this.currentindex < this.bytelength - 1) {
            if (10 == this.buffer[this.currentindex] && 10 == this.buffer[this.currentindex + 1]) {
                endloc = this.currentindex - 1;
                break;
            }
            ++this.currentindex;
        }
        if (endloc == 0) {
            if (this.lastblock) {
                endloc = this.bytelength - 1;
            } else {
                int len2 = this.fis.read(this.buffer, this.bytelength, this.bytelength);
                if (len2 <= 0) {
                    throw new IOException("Read " + len2 + " bytes for " + this.inputFileName + " block " + this.blockindex + 1);
                }
                this.fis.close();
                this.spilled = true;
                this.bytelength += len2;
            }
            while (this.currentindex < this.bytelength - 1) {
                if (10 == this.buffer[this.currentindex] && 10 == this.buffer[this.currentindex + 1]) {
                    endloc = this.currentindex - 1;
                    break;
                }
                ++this.currentindex;
            }
            endloc = this.currentindex - 1;
        }
        byte[] docbytes = Arrays.copyOfRange(this.buffer, startloc, endloc);
        this.nextDoc = new String(docbytes, this.encoding);
        this.nextDocOffset = startloc;
        return true;
    }

    private String getNextDocument() {
        return this.nextDoc;
    }

    private static enum NextDoc {
        FIRSTDOC,
        SEP_IN_LASTBLOCK,
        NORMAL;

    }
}

