/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.randomsleep;

import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;

public class SleepMultiplier
extends CasMultiplier_ImplBase {
    String CM_Identifier = "*^^^^^^^^^ CM ";
    LinkedList<CAS> work = new LinkedList();

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        System.out.println(this.CM_Identifier + "Multiplier init called");
    }

    public void destroy() {
        System.out.println(this.CM_Identifier + " Destroy is called (0)");
        System.out.println(this.CM_Identifier + "Destroy exits");
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        String data = cas.getSofaDataString();
        System.out.println(this.CM_Identifier + "Multiplier process CAS. Data: " + data);
        this.work.add(cas);
    }

    public boolean hasNext() throws AnalysisEngineProcessException {
        System.out.println(this.CM_Identifier + " hasNext: true");
        return this.work.size() > 0;
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        CAS nextCas = this.work.removeFirst();
        String data = nextCas.getSofaDataString();
        StringTokenizer tok = new StringTokenizer(data);
        long elapsed = Long.parseLong(tok.nextToken());
        int seqno = Integer.parseInt(tok.nextToken());
        int total = Integer.parseInt(tok.nextToken());
        String logid = tok.nextToken();
        System.out.println(this.CM_Identifier + "next returns: Work Item(" + seqno + ") Sleep Time(" + elapsed + ") of total(" + total + ") logid(" + logid + ") pass to AE");
        CAS cas = this.getEmptyCAS();
        cas.setSofaDataString(data, "text");
        return cas;
    }
}

