/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.maintenance;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;

public class NodeAccounting {
    private static final DuccLogger logger = DuccLogger.getLogger(NodeAccounting.class);
    private static final DuccId jobid = null;
    private static NodeAccounting instance = new NodeAccounting();
    private ConcurrentHashMap<String, Long> timeMap = new ConcurrentHashMap();
    private long inventoryRate = 30000L;
    private long inventorySkip = 0L;
    private long heartbeatMissingTolerance = 3L;
    private boolean inventoryRateMessage = false;
    private boolean inventorySkipMessage = false;

    public static NodeAccounting getInstance() {
        return instance;
    }

    private long getRate() {
        long retVal;
        block4: {
            String methodName = "getRate";
            retVal = this.inventoryRate;
            try {
                long property_value;
                String property_inventory_rate = DuccPropertiesResolver.getInstance().getFileProperty("ducc.agent.node.inventory.publish.rate");
                if (property_inventory_rate == null) {
                    property_inventory_rate = "" + this.inventoryRate;
                }
                if ((property_value = Long.parseLong(property_inventory_rate.trim())) != this.inventoryRate) {
                    this.inventoryRate = property_value;
                    logger.info(methodName, jobid, new Object[]{"rate:" + this.inventoryRate});
                }
                retVal = property_value;
            }
            catch (Throwable t) {
                if (this.inventoryRateMessage) break block4;
                this.inventoryRateMessage = true;
                logger.warn(methodName, jobid, t, new Object[0]);
            }
        }
        return retVal;
    }

    private long getSkip() {
        long retVal;
        block4: {
            String methodName = "getSkip";
            retVal = this.inventorySkip;
            try {
                long property_value;
                String property_inventory_skip = DuccPropertiesResolver.getInstance().getFileProperty("ducc.agent.node.inventory.publish.rate.skip");
                if (property_inventory_skip == null) {
                    property_inventory_skip = "" + this.inventorySkip;
                }
                if ((property_value = Long.parseLong(property_inventory_skip.trim())) != this.inventorySkip) {
                    this.inventorySkip = property_value;
                    logger.info(methodName, jobid, new Object[]{"skip:" + this.inventorySkip});
                }
                retVal = property_value;
            }
            catch (Throwable t) {
                if (this.inventorySkipMessage) break block4;
                this.inventorySkipMessage = true;
                logger.warn(methodName, jobid, t, new Object[0]);
            }
        }
        return retVal;
    }

    private long getNodeMissingTime() {
        String methodName = "getNodeMissingTime";
        long retVal = this.inventoryRate * this.heartbeatMissingTolerance;
        try {
            long rate = this.getRate();
            long skip = this.getSkip();
            if (skip > 0L) {
                rate *= skip;
            }
            retVal = rate * this.heartbeatMissingTolerance;
        }
        catch (Throwable t) {
            logger.error(methodName, jobid, t, new Object[0]);
        }
        return retVal;
    }

    public void heartbeat(HashMap<DuccId, IDuccProcess> processMap) {
        String location = "heartbeat";
        try {
            Iterator<DuccId> iterator = processMap.keySet().iterator();
            if (iterator.hasNext()) {
                DuccId duccId = iterator.next();
                IDuccProcess process = processMap.get(duccId);
                NodeIdentity nodeIdentity = process.getNodeIdentity();
                String nodeName = nodeIdentity.getCanonicalName();
                this.heartbeat(nodeName);
            }
        }
        catch (Throwable t) {
            logger.error(location, jobid, new Object[]{""});
        }
    }

    public void heartbeat(String nodeName) {
        String location = "heartbeat";
        this.record(nodeName);
        logger.debug(location, jobid, new Object[]{nodeName});
    }

    private void record(String nodeName) {
        if (nodeName != null) {
            Long value = new Long(System.currentTimeMillis());
            this.timeMap.put(nodeName, value);
        }
    }

    public boolean isAlive(String nodeName) {
        String location = "isAlive";
        boolean retVal = true;
        try {
            if (!this.timeMap.containsKey(nodeName)) {
                this.record(nodeName);
            }
            long heartbeatTime = this.timeMap.get(nodeName);
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - heartbeatTime;
            if (elapsed > this.getNodeMissingTime()) {
                retVal = false;
                logger.info(location, jobid, new Object[]{"down:" + nodeName + " elapsed:" + elapsed});
            }
        }
        catch (Throwable t) {
            logger.error(location, jobid, new Object[]{nodeName});
        }
        return retVal;
    }
}

