/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.vinci.transport.vns;

/**
 * Constants used in documents communicated to and from VNS ("Vinci Naming Service").
 */
public class VNSConstants {
  public static final String SERVEON_COMMAND = "serveon";

  public static final String RESOLVE_COMMAND = "resolve";

  public static final String SERVICE_KEY = "SERVICE";

  public static final String SERVER_KEY = "SERVER";

  public static final String HOST_KEY = "HOST";

  public static final String PORT_KEY = "PORT";

  public static final String LEVEL_KEY = "LEVEL";

  public static final String INSTANCE_KEY = "INSTANCE";
}
