/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl.compatibility;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.BaseAnnotator;
import org.apache.uima.analysis_engine.annotator.GenericAnnotator;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator;
import org.apache.uima.analysis_engine.annotator.TextAnnotator;
import org.apache.uima.analysis_engine.impl.AnnotatorContext_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;

public class AnnotatorAdapter
implements AnalysisComponent {
    private BaseAnnotator mAnnotator;
    private Class<? extends AbstractCas> mCasInterface;
    private TypeSystem mLastTypeSystem;
    private ResultSpecification mDefaultResultSpecification;
    private Map<String, ResultSpecification> mLanguageToResultSpecMap = new HashMap<String, ResultSpecification>();

    public AnnotatorAdapter(BaseAnnotator aAnnotator, AnalysisEngineMetaData aMetaData, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        this.mAnnotator = aAnnotator;
        if (aMetaData.isSofaAware() && (this.mAnnotator instanceof TextAnnotator || this.mAnnotator instanceof JTextAnnotator)) {
            throw new ResourceInitializationException("text_annotator_cannot_be_sofa_aware", new Object[]{aMetaData.getName(), this.mAnnotator instanceof TextAnnotator ? "TextAnnotator" : "JTextAnnotator", aMetaData.getSourceUrlString()});
        }
        this.mCasInterface = this.mAnnotator instanceof JTextAnnotator ? JCas.class : CAS.class;
    }

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        try {
            AnnotatorContext_impl actxt = new AnnotatorContext_impl((UimaContextAdmin)aContext);
            this.mAnnotator.initialize(actxt);
        }
        catch (AnnotatorInitializationException e) {
            throw new ResourceInitializationException(e);
        }
        catch (AnnotatorConfigurationException e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
        this.mDefaultResultSpecification = aResultSpec;
        this.mLanguageToResultSpecMap = new HashMap<String, ResultSpecification>();
    }

    @Override
    public void process(AbstractCas aCAS) throws AnalysisEngineProcessException {
        if (!this.mCasInterface.isAssignableFrom(aCAS.getClass())) {
            throw new AnalysisEngineProcessException("incorrect_cas_interface", new Object[]{this.mCasInterface, aCAS.getClass()});
        }
        this.checkTypeSystemChange(aCAS);
        try {
            BaseAnnotator baseAnnotator = this.mAnnotator;
            if (baseAnnotator instanceof TextAnnotator) {
                TextAnnotator textAnnotator = (TextAnnotator)baseAnnotator;
                cas = (CAS)aCAS;
                ResultSpecification rs = this.getResultSpecForLanguage(cas.getDocumentLanguage());
                rs.setTypeSystem(cas.getTypeSystem());
                textAnnotator.process((CAS)cas, rs);
            } else {
                cas = this.mAnnotator;
                if (cas instanceof JTextAnnotator) {
                    JTextAnnotator jTextAnnotator = (JTextAnnotator)cas;
                    JCas jcas = (JCas)aCAS;
                    ResultSpecification rs = this.getResultSpecForLanguage(jcas.getDocumentLanguage());
                    rs.setTypeSystem(jcas.getTypeSystem());
                    jTextAnnotator.process(jcas, rs);
                } else {
                    baseAnnotator = this.mAnnotator;
                    if (baseAnnotator instanceof GenericAnnotator) {
                        GenericAnnotator genericAnnotator = (GenericAnnotator)baseAnnotator;
                        this.mDefaultResultSpecification.setTypeSystem(((CAS)aCAS).getTypeSystem());
                        genericAnnotator.process((CAS)aCAS, this.mDefaultResultSpecification);
                    }
                }
            }
        }
        catch (AnnotatorProcessException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    private ResultSpecification getResultSpecForLanguage(String language) {
        ResultSpecification rs = this.mLanguageToResultSpecMap.get(language);
        if (rs == null) {
            TypeOrFeature[] tofs = this.mDefaultResultSpecification.getResultTypesAndFeatures(language);
            if (tofs.length > 0) {
                rs = UIMAFramework.getResourceSpecifierFactory().createResultSpecification();
                rs.setResultTypesAndFeatures(tofs);
            } else {
                rs = this.mDefaultResultSpecification;
            }
            this.mLanguageToResultSpecMap.put(language, rs);
        }
        return rs;
    }

    public void checkTypeSystemChange(AbstractCas aCAS) throws AnalysisEngineProcessException {
        try {
            TypeSystem typeSystem;
            if (aCAS instanceof JCas) {
                JCas jCas = (JCas)aCAS;
                typeSystem = jCas.getTypeSystem();
            } else {
                typeSystem = ((CAS)aCAS).getTypeSystem();
            }
            if (typeSystem != this.mLastTypeSystem) {
                this.mAnnotator.typeSystemInit(typeSystem);
                this.mLastTypeSystem = typeSystem;
            }
        }
        catch (AnnotatorConfigurationException | AnnotatorInitializationException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
    }

    @Override
    public void destroy() {
        this.mAnnotator.destroy();
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException, ResourceInitializationException {
        try {
            this.mAnnotator.reconfigure();
        }
        catch (AnnotatorConfigurationException e) {
            throw new ResourceConfigurationException(e);
        }
        catch (AnnotatorInitializationException e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public boolean hasNext() throws AnalysisEngineProcessException {
        return false;
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        throw new UIMA_UnsupportedOperationException("unsupported_method", new Object[]{AnnotatorAdapter.class, "next"});
    }

    @Override
    public Class<? extends AbstractCas> getRequiredCasInterface() {
        return this.mCasInterface;
    }

    @Override
    public int getCasInstancesRequired() {
        return 0;
    }

    protected BaseAnnotator getAnnotator() {
        return this.mAnnotator;
    }
}

