/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.validation.CasValidationCheck;
import org.apache.uima.fit.validation.JCasValidationCheck;
import org.apache.uima.fit.validation.ValidationCheck;
import org.apache.uima.fit.validation.ValidationCheckException;
import org.apache.uima.fit.validation.ValidationCheckSkippedException;
import org.apache.uima.fit.validation.ValidationException;
import org.apache.uima.fit.validation.ValidationResult;
import org.apache.uima.fit.validation.ValidationSummary;
import org.apache.uima.jcas.JCas;

public class Validator {
    private Collection<ValidationCheck> checks;

    public Validator(Collection<ValidationCheck> checks) {
        this.checks = checks;
    }

    public ValidationSummary check(JCas aJCas) throws ValidationException {
        ValidationSummary summary = new ValidationSummary();
        for (ValidationCheck check : this.checks) {
            try {
                summary.add(ValidationResult.trace(check, "Trying check...", new Object[0]));
                if (check instanceof CasValidationCheck) {
                    summary.addAll(((CasValidationCheck)check).validate(aJCas.getCas()));
                    continue;
                }
                if (check instanceof JCasValidationCheck) {
                    summary.addAll(((JCasValidationCheck)check).validate(aJCas));
                    continue;
                }
                throw new IllegalArgumentException("Unknown ValidationCheck type: [" + check.getClass().getName() + "]");
            }
            catch (ValidationCheckSkippedException e) {
                summary.add(ValidationResult.info(check, "Skipped check: %s", e.getMessage()));
            }
            catch (ValidationCheckException e) {
                summary.add(ValidationResult.error(check, "%s", e.getMessage()));
            }
        }
        return summary;
    }

    public ValidationSummary check(CAS cas) throws ValidationException {
        ValidationSummary summary = new ValidationSummary();
        for (ValidationCheck check : this.checks) {
            try {
                summary.add(ValidationResult.trace(check, "Trying check...", new Object[0]));
                if (check instanceof CasValidationCheck) {
                    summary.addAll(((CasValidationCheck)check).validate(cas));
                    continue;
                }
                if (check instanceof JCasValidationCheck) {
                    try {
                        summary.addAll(((JCasValidationCheck)check).validate(cas.getJCas()));
                        continue;
                    }
                    catch (CASException e) {
                        throw new ValidationException(e);
                    }
                }
                throw new IllegalArgumentException("Unknown ValidationCheck type: [" + check.getClass().getName() + "]");
            }
            catch (ValidationCheckSkippedException e) {
                summary.add(ValidationResult.info(check, "Skipped check: %s", e.getMessage()));
            }
            catch (ValidationCheckException e) {
                summary.add(ValidationResult.error(check, "%s", e.getMessage()));
            }
        }
        return summary;
    }

    public Collection<ValidationCheck> getChecks() {
        return this.checks;
    }

    public static class Builder {
        private final Set<ValidationCheck> checks = new LinkedHashSet<ValidationCheck>();
        private final Set<Pattern> includePatterns = new HashSet<Pattern>();
        private final Set<Class<?>> includeTypes = new HashSet();
        private final Set<Pattern> excludePatterns = new HashSet<Pattern>();
        private final Set<Class<?>> excludeTypes = new HashSet();
        private boolean skipAutoDetection = false;

        public Builder withCheck(CasValidationCheck check) {
            this.checks.add(check);
            return this;
        }

        public Builder withoutAutoDetectedChecks() {
            this.skipAutoDetection = true;
            return this;
        }

        public Builder withAutoDetectedChecks() {
            this.skipAutoDetection = false;
            return this;
        }

        public Builder excludingByName(String ... className) {
            Arrays.stream(className).map(Pattern::quote).map(Pattern::compile).forEach(this.excludePatterns::add);
            return this;
        }

        public Builder excludingByPattern(String ... patterns) {
            Arrays.stream(patterns).map(Pattern::compile).forEach(this.excludePatterns::add);
            return this;
        }

        public Builder excludingByType(Class<?> ... types) {
            Arrays.stream(types).forEach(this.excludeTypes::add);
            return this;
        }

        public Builder includingByName(String ... className) {
            Arrays.stream(className).map(Pattern::quote).map(Pattern::compile).forEach(this.includePatterns::add);
            return this;
        }

        public Builder includingByPattern(String ... patterns) {
            Arrays.stream(patterns).map(Pattern::compile).forEach(this.includePatterns::add);
            return this;
        }

        public Builder includingByType(Class<?> ... types) {
            Arrays.stream(types).forEach(this.includeTypes::add);
            return this;
        }

        private Builder autoDetectChecks() {
            StreamSupport.stream(ServiceLoader.load(ValidationCheck.class).spliterator(), false).forEachOrdered(this.checks::add);
            return this;
        }

        public Validator build() {
            if (!this.skipAutoDetection) {
                this.autoDetectChecks();
            }
            if (!this.includePatterns.isEmpty()) {
                this.checks.removeIf(check -> this.includePatterns.stream().noneMatch(p -> p.matcher(check.getClass().getName()).matches()));
            }
            if (!this.includeTypes.isEmpty()) {
                this.checks.removeIf(check -> this.includeTypes.stream().noneMatch(t -> t.isAssignableFrom(check.getClass())));
            }
            if (!this.excludePatterns.isEmpty()) {
                this.checks.removeIf(check -> this.excludePatterns.stream().anyMatch(p -> p.matcher(check.getClass().getName()).matches()));
            }
            if (!this.excludeTypes.isEmpty()) {
                this.checks.removeIf(check -> this.excludeTypes.stream().anyMatch(t -> t.isAssignableFrom(check.getClass())));
            }
            return new Validator(this.checks);
        }
    }
}

