/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.util;

import java.io.UTFDataFormatException;

public class UTFConverter {
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    private UTFConverter() {
    }

    public static float convertUTFToFloat(byte[] bytearr) throws UTFDataFormatException, NumberFormatException {
        return Float.parseFloat(UTFConverter.convertUTFToString(bytearr));
    }

    public static double convertUTFToDouble(byte[] bytearr) throws UTFDataFormatException, NumberFormatException {
        return Double.parseDouble(UTFConverter.convertUTFToString(bytearr));
    }

    public static boolean convertUTFToBool(byte[] bytearr) throws UTFDataFormatException {
        return TRUE_VALUE.equals(UTFConverter.convertUTFToString(bytearr));
    }

    public static int convertUTFToInt(byte[] bytearr) throws UTFDataFormatException, NumberFormatException {
        return Integer.parseInt(UTFConverter.convertUTFToString(bytearr));
    }

    public static long convertUTFToLong(byte[] bytearr) throws UTFDataFormatException, NumberFormatException {
        return Long.parseLong(UTFConverter.convertUTFToString(bytearr));
    }

    public static String convertUTFToString(byte[] bytearr) throws UTFDataFormatException {
        char[] result = new char[bytearr.length];
        int outputLength = UTFConverter.convertUTFToString(bytearr, 0, bytearr.length, result);
        return new String(result, 0, outputLength);
    }

    public static int convertUTFToString(byte[] bytearr, int beginOffset, int inputLength, char[] result) throws UTFDataFormatException {
        int outputLength = 0;
        int count = beginOffset;
        int endOffset = inputLength + count;
        block5: while (count < endOffset) {
            int c1 = bytearr[count++] & 0xFF;
            switch (c1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    result[outputLength++] = (char)c1;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if (count + 1 > inputLength) {
                        throw new UTFDataFormatException();
                    }
                    byte c2 = bytearr[count++];
                    result[outputLength++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if (count + 2 > inputLength) {
                        throw new UTFDataFormatException();
                    }
                    byte c2 = bytearr[count++];
                    byte c3 = bytearr[count++];
                    result[outputLength++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return outputLength;
    }

    public static byte[] convertStringToUTF(String inputString) {
        int resultLength = UTFConverter.calculateUTFLength(inputString);
        byte[] resultArray = new byte[resultLength];
        UTFConverter.convertStringToUTF(inputString, resultArray);
        return resultArray;
    }

    public static byte[] convertStringToUTF(char[] inputArray, int startOffset, int endOffset) {
        int resultLength = UTFConverter.calculateUTFLength(inputArray, startOffset, endOffset);
        byte[] resultArray = new byte[resultLength];
        UTFConverter.convertStringToUTF(inputArray, startOffset, endOffset, resultArray);
        return resultArray;
    }

    public static int calculateUTFLength(char[] inputArray, int startOffset, int endOffset) {
        int resultLength = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            char c = inputArray[i];
            if (c >= '\u0000' && c <= '\u007f') {
                ++resultLength;
                continue;
            }
            if (c > '\u07ff') {
                resultLength += 3;
                continue;
            }
            resultLength += 2;
        }
        return resultLength;
    }

    public static int calculateUTFLength(String inputString) {
        int resultLength = 0;
        int inputLength = inputString.length();
        for (int i = 0; i < inputLength; ++i) {
            char c = inputString.charAt(i);
            if (c >= '\u0000' && c <= '\u007f') {
                ++resultLength;
                continue;
            }
            if (c > '\u07ff') {
                resultLength += 3;
                continue;
            }
            resultLength += 2;
        }
        return resultLength;
    }

    public static int convertStringToUTF(char[] inputArray, int startOffset, int endOffset, byte[] resultArray) {
        int resultLength = 0;
        resultLength = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            char c = inputArray[i];
            if (c >= '\u0000' && c <= '\u007f') {
                resultArray[resultLength++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                resultArray[resultLength++] = (byte)(0xE0 | c >> 12 & 0xF);
                resultArray[resultLength++] = (byte)(0x80 | c >> 6 & 0x3F);
                resultArray[resultLength++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            resultArray[resultLength++] = (byte)(0xC0 | c >> 6 & 0x1F);
            resultArray[resultLength++] = (byte)(0x80 | c & 0x3F);
        }
        return resultLength;
    }

    public static int convertStringToUTF(String inputString, byte[] resultArray) {
        int resultLength = 0;
        int inputLength = inputString.length();
        for (int i = 0; i < inputLength; ++i) {
            char c = inputString.charAt(i);
            if (c >= '\u0000' && c <= '\u007f') {
                resultArray[resultLength++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                resultArray[resultLength++] = (byte)(0xE0 | c >> 12 & 0xF);
                resultArray[resultLength++] = (byte)(0x80 | c >> 6 & 0x3F);
                resultArray[resultLength++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            resultArray[resultLength++] = (byte)(0xC0 | c >> 6 & 0x1F);
            resultArray[resultLength++] = (byte)(0x80 | c & 0x3F);
        }
        return resultLength;
    }
}

