/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;

public class AnalysisEnginePerformanceReports {
    private ProcessTrace mProcessTrace;
    private Map<String, Integer> mAnnotatorAnalysisTimes = new HashMap<String, Integer>();
    private int mAnalysisTime = 0;
    private int mFrameworkOverhead = 0;
    private int mServiceWrapperOverhead = 0;
    private int mServiceCallOverhead = 0;
    private int mTotalTime = 0;
    private NumberFormat pctFormat;

    public AnalysisEnginePerformanceReports(ProcessTrace aProcessTrace) {
        this.mProcessTrace = aProcessTrace;
        this.pctFormat = NumberFormat.getPercentInstance();
        this.pctFormat.setMaximumFractionDigits(2);
        for (ProcessTraceEvent evt : aProcessTrace.getEvents()) {
            if ("ANALYSIS_ENGINE".equals(evt.getType()) || "SERVICE_CALL".equals(evt.getType())) {
                this.mTotalTime += evt.getDuration();
            }
            this.addEventData(evt);
        }
    }

    protected void addEventData(ProcessTraceEvent aEvent) {
        if ("ANALYSIS".equals(aEvent.getType())) {
            this.mAnalysisTime += aEvent.getDuration();
            String componentName = aEvent.getComponentName();
            this.mAnnotatorAnalysisTimes.put(componentName, aEvent.getDuration());
        } else if ("ANALYSIS_ENGINE".equals(aEvent.getType())) {
            subEventTypes = new String[]{"ANALYSIS", "ANALYSIS_ENGINE"};
            duration = aEvent.getDuration();
            subEventDuration = this.getSubEventDuration(aEvent, subEventTypes);
            if (subEventDuration > 0) {
                this.mFrameworkOverhead += duration - subEventDuration;
            }
        } else if ("SERVICE".equals(aEvent.getType())) {
            subEventTypes = new String[]{"ANALYSIS", "ANALYSIS_ENGINE"};
            duration = aEvent.getDuration();
            subEventDuration = this.getSubEventDuration(aEvent, subEventTypes);
            if (subEventDuration > 0) {
                this.mServiceWrapperOverhead += duration - subEventDuration;
            }
        } else if ("SERVICE_CALL".equals(aEvent.getType())) {
            subEventTypes = new String[]{"SERVICE", "ANALYSIS", "ANALYSIS_ENGINE"};
            duration = aEvent.getDuration();
            subEventDuration = this.getSubEventDuration(aEvent, subEventTypes);
            if (subEventDuration > 0) {
                this.mServiceCallOverhead += duration - subEventDuration;
            }
        }
        for (ProcessTraceEvent subEvt : aEvent.getSubEvents()) {
            this.addEventData(subEvt);
        }
    }

    public int getTotalTime() {
        return this.mTotalTime;
    }

    public int getAnalysisTime() {
        return this.mAnalysisTime;
    }

    public int getFrameworkOverhead() {
        return this.mFrameworkOverhead;
    }

    public int getServiceWrapperOverhead() {
        return this.mServiceWrapperOverhead;
    }

    public int getServiceCallOverhead() {
        return this.mServiceCallOverhead;
    }

    public String getFullReport() {
        return this.mProcessTrace.toString();
    }

    public String toString() {
        int total = this.getTotalTime();
        int analysis = this.getAnalysisTime();
        int frameworkOver = this.getFrameworkOverhead();
        int serviceWrapperOver = this.getServiceWrapperOverhead();
        int serviceCallOver = this.getServiceCallOverhead();
        StringBuilder buf = new StringBuilder();
        buf.append("Total Analysis Engine Time: ").append(total).append("ms\n");
        if (analysis > 0) {
            buf.append("Annotator Time: ").append(this.getAnalysisTime()).append("ms (").append(this.toPct(analysis, total)).append(")\n");
        } else {
            buf.append("Analysis: <10ms\n");
        }
        if (frameworkOver > 0) {
            buf.append("Framework Overhead: ").append(frameworkOver).append("ms (").append(this.toPct(frameworkOver, total)).append(")\n");
        } else {
            buf.append("Framework Overhead: <10ms\n");
        }
        if (serviceCallOver > 0) {
            buf.append("Service Wrapper Overhead: ").append(serviceWrapperOver).append("ms (").append(this.toPct(serviceWrapperOver, total)).append(")\n");
            buf.append("Service Call Overhead: ").append(serviceCallOver).append("ms (").append(this.toPct(serviceCallOver, total)).append(")\n");
        }
        return buf.toString();
    }

    private String toPct(long aNumerator, long aDenominator) {
        return this.pctFormat.format((double)aNumerator / (double)aDenominator);
    }

    private int getSubEventDuration(ProcessTraceEvent aEvent, String[] aEventTypes) {
        int duration = 0;
        List<ProcessTraceEvent> subEvents = aEvent.getSubEvents();
        block0: for (ProcessTraceEvent evt : subEvents) {
            String type = evt.getType();
            for (int i = 0; i < aEventTypes.length; ++i) {
                if (!aEventTypes[i].equals(type)) continue;
                duration += evt.getDuration();
                continue block0;
            }
            duration += this.getSubEventDuration(evt, aEventTypes);
        }
        return duration;
    }
}

