/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2ObjListMap;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.jcas.cas.AnnotationBase;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class CasCopier {
    private static final TypeImpl MISSING_TYPE = TypeImpl.singleton;
    private static final FeatureImpl MISSING_FEAT = FeatureImpl.singleton;
    private final CASImpl originalSrcCas;
    private final CASImpl originalTgtCas;
    private CASImpl srcCasViewImpl;
    private CASImpl tgtCasViewImpl;
    private String srcViewName;
    private String tgtViewName;
    private final TypeSystemImpl srcTsi;
    private final TypeSystemImpl tgtTsi;
    private final Int2ObjListMap<TypeImpl> src2TgtType;
    private final Int2ObjListMap<FeatureImpl> src2TgtFeat;
    private final boolean isEqualTypeSystems;
    private String cachedSrcViewName = "";
    private CASImpl cachedTgtView = null;
    private boolean isChangeViewName = false;
    private Annotation srcCasDocumentAnnotation = null;
    private final boolean lenient;
    private final Map<TOP, TOP> mFsMap;
    private final Deque<Runnable> fsToDo = new ArrayDeque<Runnable>();

    public CasCopier(CAS aSrcCas, CAS aDestCas) {
        this(aSrcCas, aDestCas, false);
    }

    public CasCopier(CAS aSrcCas, CAS aDestCas, boolean lenient) {
        this.mFsMap = new IdentityHashMap<TOP, TOP>(((CASImpl)aSrcCas.getLowLevelCAS()).getLastUsedFsId());
        this.originalSrcCas = (CASImpl)aSrcCas.getLowLevelCAS();
        this.originalTgtCas = (CASImpl)aDestCas.getLowLevelCAS();
        this.srcTsi = this.originalSrcCas.getTypeSystemImpl();
        this.tgtTsi = this.originalTgtCas.getTypeSystemImpl();
        this.src2TgtType = this.srcTsi == this.tgtTsi ? null : new Int2ObjListMap(this.srcTsi.getTypeArraySize());
        this.src2TgtFeat = this.srcTsi == this.tgtTsi ? null : new Int2ObjListMap(this.srcTsi.getNumberOfFeatures() + 1);
        this.lenient = lenient;
        this.srcCasViewImpl = (CASImpl)this.originalSrcCas.getLowLevelCAS();
        this.tgtCasViewImpl = (CASImpl)this.originalTgtCas.getLowLevelCAS();
        this.srcViewName = this.srcCasViewImpl.getViewName();
        this.tgtViewName = this.tgtCasViewImpl.getViewName();
        this.isChangeViewName = this.srcViewName == null ? this.tgtViewName != null : !this.srcViewName.equals(this.tgtViewName);
        this.isEqualTypeSystems = this.srcTsi.equals(this.tgtTsi);
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa) {
        CasCopier.copyCas(aSrcCas, aDestCas, aCopySofa, false);
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa, boolean lenient) {
        CasCopier copier = new CasCopier(aSrcCas, aDestCas, lenient);
        if (copier.originalSrcCas.getBaseCAS() == copier.originalTgtCas.getBaseCAS()) {
            throw new UIMARuntimeException("illegal_cas_copy_to_same_cas", new Object[0]);
        }
        Iterator viewIterator = aSrcCas.getViewIterator();
        while (viewIterator.hasNext()) {
            CAS view = (CAS)viewIterator.next();
            copier.copyCasView(view, aCopySofa);
        }
    }

    public void copyCasView(CAS aSrcCasView, boolean aCopySofa) {
        this.copyCasViewDifferentCASs(aSrcCasView, CasCopier.getOrCreateView(this.originalTgtCas, aSrcCasView.getViewName()), aCopySofa);
    }

    public void copyCasView(String aSrcCasViewName, boolean aCopySofa) {
        this.copyCasView(CasCopier.getOrCreateView(this.originalSrcCas, aSrcCasViewName), aCopySofa);
    }

    public void copyCasView(CAS aSrcCasView, String aTgtCasViewName, boolean aCopySofa) {
        this.copyCasView(aSrcCasView, (CAS)CasCopier.getOrCreateView(this.originalTgtCas, aTgtCasViewName), aCopySofa);
    }

    public void copyCasView(String aSrcCasViewName, CAS aTgtCasView, boolean aCopySofa) {
        this.copyCasView((CAS)CasCopier.getOrCreateView(this.originalSrcCas, aSrcCasViewName), aTgtCasView, aCopySofa);
    }

    private void copyCasViewDifferentCASs(CAS aSrcCasView, CAS aTgtCasView, boolean aCopySofa) {
        if (this.originalSrcCas.getBaseCAS() == this.originalTgtCas.getBaseCAS()) {
            throw new UIMARuntimeException("illegal_cas_copy_to_same_cas", new Object[0]);
        }
        this.copyCasView(aSrcCasView, aTgtCasView, aCopySofa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCasView(CAS aSrcCasView, CAS aTgtCasView, boolean aCopySofa) {
        if (!this.casViewsInSameCas(aSrcCasView, this.originalSrcCas)) {
            throw new UIMARuntimeException("view_not_part_of_cas", "Source");
        }
        if (!this.casViewsInSameCas(aTgtCasView, this.originalTgtCas)) {
            throw new UIMARuntimeException("view_not_part_of_cas", "Destination");
        }
        this.srcCasViewImpl = (CASImpl)aSrcCasView.getLowLevelCAS();
        this.tgtCasViewImpl = (CASImpl)aTgtCasView.getLowLevelCAS();
        try {
            Sofa sofa;
            this.srcViewName = this.srcCasViewImpl.getViewName();
            this.tgtViewName = this.tgtCasViewImpl.getViewName();
            boolean bl = this.isChangeViewName = !this.srcViewName.equals(this.tgtViewName);
            if (aSrcCasView == this.srcCasViewImpl.getBaseCAS() || aTgtCasView == this.tgtCasViewImpl.getBaseCAS()) {
                throw new UIMARuntimeException("unsupported_cas_copy_view_base_cas", new Object[0]);
            }
            this.srcCasDocumentAnnotation = null;
            if (aCopySofa && null != (sofa = this.srcCasViewImpl.getSofa())) {
                String sofaMime = sofa.getSofaMime();
                String docTxt = this.srcCasViewImpl.getDocumentText();
                if (docTxt != null) {
                    aTgtCasView.setSofaDataString(docTxt, sofaMime);
                } else {
                    String sofaDataURI = this.srcCasViewImpl.getSofaDataURI();
                    if (sofaDataURI != null) {
                        aTgtCasView.setSofaDataURI(sofaDataURI, sofaMime);
                    } else {
                        TOP sofaDataArray = (TOP)this.srcCasViewImpl.getSofaDataArray();
                        if (sofaDataArray != null) {
                            aTgtCasView.setSofaDataArray(this.copyFs2Fs(sofaDataArray), sofaMime);
                        }
                    }
                }
            }
            PositiveIntSet_impl indexedFsAlreadyCopied = new PositiveIntSet_impl();
            Collection c = this.srcCasViewImpl.getIndexRepository().getIndexedFSs();
            for (TOP fs : c) {
                if (indexedFsAlreadyCopied.contains(fs._id())) continue;
                TOP copyOfFs = this.copyFs2(fs);
                if (this.lenient && copyOfFs == null) continue;
                this.tgtCasViewImpl.getIndexRepository().addFS(copyOfFs);
                indexedFsAlreadyCopied.add(fs._id());
            }
        }
        finally {
            this.srcCasViewImpl = null;
            this.tgtCasViewImpl = null;
            this.isChangeViewName = false;
        }
    }

    public <T extends FeatureStructure> T copyFs(T aFS) {
        if (null == this.srcCasViewImpl) {
            this.srcCasViewImpl = this.originalSrcCas;
        }
        if (null == this.tgtCasViewImpl) {
            this.tgtCasViewImpl = this.originalTgtCas;
        }
        this.srcCasDocumentAnnotation = null;
        return (T)this.copyFs2Fs((TOP)aFS);
    }

    private TOP copyFs2(TOP aFS) {
        TOP copy = this.copyFsInner(aFS);
        while (this.fsToDo.size() > 0) {
            Runnable r = this.fsToDo.removeFirst();
            r.run();
        }
        return copy;
    }

    private TOP copyFs2Fs(TOP fs) {
        return this.copyFs2(fs);
    }

    private TOP copyFsInner(TOP srcFs) {
        Annotation destDocAnnot;
        TOP copy = this.mFsMap.get(srcFs);
        if (copy != null) {
            return copy;
        }
        if (srcFs instanceof Sofa) {
            Sofa srcSofa = (Sofa)srcFs;
            return this.getCorrespondingTgtView(srcSofa.getSofaID()).getSofa();
        }
        String viewName = srcFs._casView.getViewName();
        CASImpl tgtView = srcFs instanceof AnnotationBase ? (viewName == null ? this.tgtCasViewImpl : this.getCorrespondingTgtView(viewName)) : this.tgtCasViewImpl;
        TypeImpl tgtTi = this.getTargetType(srcFs._getTypeImpl());
        if (null == tgtTi) {
            return null;
        }
        if (this.isDocumentAnnotation(srcFs) && (destDocAnnot = (Annotation)tgtView.getDocumentAnnotationNoCreate()) != null) {
            destDocAnnot.removeFromIndexes();
        }
        if (srcFs instanceof CommonArrayFS) {
            copy = this.copyArray(srcFs);
            if (copy != null) {
                this.mFsMap.put(srcFs, copy);
            }
            return copy;
        }
        TOP tgtFs = (TOP)tgtView.createFS(tgtTi);
        this.mFsMap.put(srcFs, tgtFs);
        this.fsToDo.addLast(() -> {
            if (srcFs instanceof UimaSerializable) {
                ((UimaSerializable)((Object)srcFs))._save_to_cas_data();
            }
            this.copyFeatures(srcFs, tgtFs);
            if (tgtFs instanceof UimaSerializable) {
                ((UimaSerializable)((Object)tgtFs))._init_from_cas_data();
            }
        });
        return tgtFs;
    }

    private CASImpl getCorrespondingTgtView(String viewNameFromSrcSofaId) {
        if (null == viewNameFromSrcSofaId) {
            return this.tgtCasViewImpl.getBaseCAS();
        }
        if (viewNameFromSrcSofaId == this.cachedSrcViewName) {
            return this.cachedTgtView;
        }
        this.cachedSrcViewName = viewNameFromSrcSofaId;
        this.cachedTgtView = CasCopier.getOrCreateView(this.tgtCasViewImpl, this.getDestSofaId(viewNameFromSrcSofaId));
        return this.cachedTgtView;
    }

    private String getDestSofaId(String viewNameFromSrcSofaId) {
        return this.isChangeViewName && viewNameFromSrcSofaId.equals(this.srcViewName) ? this.tgtViewName : viewNameFromSrcSofaId;
    }

    private <T extends FeatureStructure> void copyFeatures(T srcFSi, T tgtFSi) {
        TOP srcFS = (TOP)srcFSi;
        TypeImpl ti = srcFS._getTypeImpl();
        TOP tgtFS = (TOP)tgtFSi;
        if (this.isEqualTypeSystems) {
            for (FeatureImpl fi : ti.getFeatureImpls()) {
                TOP refFs;
                int adjOffset = fi.getAdjustedOffset();
                if (fi.isInInt) {
                    tgtFS._setIntValueNcNj(adjOffset, srcFS._getIntValueNc(adjOffset));
                    if (!fi.isLongOrDouble) continue;
                    tgtFS._setIntValueNcNj(adjOffset + 1, srcFS._getIntValueNc(adjOffset + 1));
                    continue;
                }
                if (!fi.getRangeImpl().isRefType) {
                    tgtFS._setRefValueCommon(adjOffset, srcFS._getRefValueCommon(adjOffset));
                    continue;
                }
                if (fi.isAnnotBaseSofaRef || null == (refFs = srcFS._getFeatureValueNc(adjOffset))) continue;
                tgtFS._setFeatureValueNcNj(adjOffset, (Object)this.copyFsInner(refFs));
            }
            return;
        }
        for (FeatureImpl fi : ti.getFeatureImpls()) {
            TOP refFs;
            FeatureImpl tgtFi = this.getTargetFeature(fi);
            if (null == tgtFi || CASImpl.copyFeatureExceptFsRef(srcFS, fi, tgtFS, tgtFi) || fi.isAnnotBaseSofaRef || null == (refFs = srcFS._getFeatureValueNc(fi))) continue;
            tgtFS._setFeatureValueNcNj(tgtFi, (Object)this.copyFsInner(refFs));
        }
    }

    public boolean alreadyCopied(FeatureStructure aFS) {
        return this.alreadyCopied((TOP)aFS);
    }

    public boolean alreadyCopied(TOP aFS) {
        return this.mFsMap.get(aFS) != null;
    }

    public boolean alreadyCopied(int aFS) {
        Object fs = this.originalSrcCas.getFsFromId(aFS);
        return this.mFsMap.get(fs) != null;
    }

    private TOP copyArray(TOP srcFS) {
        CommonArrayFS srcCA = (CommonArrayFS)((Object)srcFS);
        int size = srcCA.size();
        TypeImpl tgtTi = this.getTargetType(srcFS._getTypeImpl());
        if (tgtTi == null) {
            return null;
        }
        if (srcFS instanceof CommonPrimitiveArray) {
            CommonArrayFS copy = (CommonArrayFS)((Object)this.tgtCasViewImpl.createArray(tgtTi, size));
            copy.copyValuesFrom(srcCA);
            return (TOP)((Object)copy);
        }
        FSArray fsArray = (FSArray)this.tgtCasViewImpl.createArray(tgtTi, size);
        int i = 0;
        TOP[] tgtArray = fsArray._getTheArray();
        for (TOP srcItem : ((FSArray)srcFS)._getTheArray()) {
            if (null != srcItem) {
                tgtArray[i] = this.copyFsInner(srcItem);
            }
            ++i;
        }
        return fsArray;
    }

    private static CASImpl getOrCreateView(CASImpl aCas, String aViewName) {
        try {
            return (CASImpl)aCas.getView(aViewName).getLowLevelCAS();
        }
        catch (CASRuntimeException e) {
            return (CASImpl)aCas.createView(aViewName).getLowLevelCAS();
        }
    }

    private <T extends FeatureStructure> boolean isDocumentAnnotation(T aFS) {
        if (!this.srcTsi.docType.subsumes(aFS.getType())) {
            return false;
        }
        if (this.srcCasDocumentAnnotation == null) {
            this.srcCasDocumentAnnotation = (Annotation)this.srcCasViewImpl.getDocumentAnnotationNoCreate();
        }
        return aFS == this.srcCasDocumentAnnotation;
    }

    private boolean casViewsInSameCas(CAS c1, CAS c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        CASImpl ci1 = (CASImpl)c1.getLowLevelCAS();
        CASImpl ci2 = (CASImpl)c2.getLowLevelCAS();
        return ci1.getBaseCAS() == ci2.getBaseCAS();
    }

    private TypeImpl getTargetType(TypeImpl srcTi) {
        if (this.srcTsi == this.tgtTsi) {
            return srcTi;
        }
        int srcTypeCode = srcTi.getCode();
        TypeImpl r = this.src2TgtType.get(srcTypeCode);
        if (r == null) {
            r = this.tgtTsi.getType(srcTi.getName());
            this.src2TgtType.put(srcTypeCode, null == r ? MISSING_TYPE : r);
        }
        return r == MISSING_TYPE ? null : r;
    }

    private FeatureImpl getTargetFeature(FeatureImpl srcFi) {
        if (this.srcTsi == this.tgtTsi) {
            return srcFi;
        }
        return this.getTargetFeature2(srcFi);
    }

    private FeatureImpl getTargetFeature2(FeatureImpl srcFi) {
        int srcFeatCode = srcFi.getCode();
        FeatureImpl r = this.src2TgtFeat.get(srcFeatCode);
        if (r == null) {
            TypeImpl d = (TypeImpl)srcFi.getDomain();
            TypeImpl td = this.getTargetType(d);
            if (td == null) {
                return null;
            }
            r = td.getFeatureByBaseName(srcFi.getShortName());
            this.src2TgtFeat.put(srcFeatCode, null == r ? MISSING_FEAT : r);
        }
        return r == MISSING_FEAT ? null : r;
    }
}

