/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConfManager.class);
    private Map<String, String> clientConf = JavaUtils.newConcurrentMap();
    private final AtomicLong lastCandidatesUpdateMS = new AtomicLong(0L);
    private Path path;
    private ScheduledExecutorService updateClientConfSES = null;
    private FileSystem fileSystem;
    private static final String WHITESPACE_REGEX = "\\s+";
    private ApplicationManager applicationManager;

    public ClientConfManager(CoordinatorConf conf, Configuration hadoopConf, ApplicationManager applicationManager) throws Exception {
        if (conf.getBoolean(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_ENABLED)) {
            this.applicationManager = applicationManager;
            this.init(conf, hadoopConf);
        }
    }

    private void init(CoordinatorConf conf, Configuration hadoopConf) throws Exception {
        String pathStr = (String)conf.get(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_PATH);
        this.path = new Path(pathStr);
        this.fileSystem = HadoopFilesystemProvider.getFilesystem((Path)this.path, (Configuration)hadoopConf);
        if (!this.fileSystem.isFile(this.path)) {
            String msg = String.format("Fail to init ClientConfManager, %s is not a file.", this.path.toUri());
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        this.updateClientConfInternal();
        LOG.info("Load client conf from {} successfully", (Object)pathStr);
        int updateIntervalS = conf.getInteger(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_UPDATE_INTERVAL_SEC);
        this.updateClientConfSES = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"ClientConfManager");
        this.updateClientConfSES.scheduleAtFixedRate(this::updateClientConf, 0L, updateIntervalS, TimeUnit.SECONDS);
    }

    private void updateClientConf() {
        try {
            Object[] fileStatus = this.fileSystem.listStatus(this.path);
            if (!ArrayUtils.isEmpty((Object[])fileStatus)) {
                long modifiedMS = fileStatus[0].getModificationTime();
                if (this.lastCandidatesUpdateMS.get() != modifiedMS) {
                    this.updateClientConfInternal();
                    this.lastCandidatesUpdateMS.set(modifiedMS);
                    LOG.info("Update client conf from {} successfully.", (Object)this.path);
                }
            } else {
                LOG.warn("Client conf file not found with {}", (Object)this.path);
            }
        }
        catch (Exception e) {
            LOG.warn("Error when update client conf with {}.", (Object)this.path, (Object)e);
        }
    }

    private void updateClientConfInternal() {
        ConcurrentHashMap newClientConf = JavaUtils.newConcurrentMap();
        String content = this.loadClientConfContent();
        if (StringUtils.isEmpty((CharSequence)content)) {
            this.clientConf = newClientConf;
            LOG.warn("Load empty content from {}, ignore this updating.", (Object)this.path.toUri().toString());
            return;
        }
        boolean hasRemoteStorageConf = false;
        String remoteStoragePath = "";
        String remoteStorageConf = "";
        for (String item : content.split("\n")) {
            String[] confKV;
            String confItem = item.trim();
            if (StringUtils.isEmpty((CharSequence)confItem) || (confKV = confItem.split(WHITESPACE_REGEX)).length != 2) continue;
            if (CoordinatorConf.COORDINATOR_REMOTE_STORAGE_PATH.key().equals(confKV[0])) {
                hasRemoteStorageConf = true;
                remoteStoragePath = confKV[1];
                continue;
            }
            if (CoordinatorConf.COORDINATOR_REMOTE_STORAGE_CLUSTER_CONF.key().equals(confKV[0])) {
                remoteStorageConf = confKV[1];
                continue;
            }
            newClientConf.put(confKV[0], confKV[1]);
        }
        if (hasRemoteStorageConf) {
            this.applicationManager.refreshRemoteStorage(remoteStoragePath, remoteStorageConf);
        }
        this.clientConf = newClientConf;
    }

    private String loadClientConfContent() {
        String content = null;
        try (FSDataInputStream in = this.fileSystem.open(this.path);){
            content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Fail to load content from {}", (Object)this.path.toUri().toString());
        }
        return content;
    }

    public Map<String, String> getClientConf() {
        return this.clientConf;
    }

    @Override
    public void close() {
        if (this.updateClientConfSES != null) {
            this.updateClientConfSES.shutdownNow();
        }
    }
}

