/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.storage;

import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.strategy.storage.AbstractSelectStorageStrategy;
import org.apache.uniffle.coordinator.strategy.storage.RankValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppBalanceSelectStorageStrategy
extends AbstractSelectStorageStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AppBalanceSelectStorageStrategy.class);
    private final Map<String, RemoteStorageInfo> appIdToRemoteStorageInfo;
    private final Map<String, RemoteStorageInfo> availableRemoteStorageInfo;

    public AppBalanceSelectStorageStrategy(Map<String, RankValue> remoteStoragePathRankValue, Map<String, RemoteStorageInfo> appIdToRemoteStorageInfo, Map<String, RemoteStorageInfo> availableRemoteStorageInfo, CoordinatorConf conf) {
        super(remoteStoragePathRankValue, conf);
        this.appIdToRemoteStorageInfo = appIdToRemoteStorageInfo;
        this.availableRemoteStorageInfo = availableRemoteStorageInfo;
    }

    @Override
    public synchronized RemoteStorageInfo pickStorage(String appId) {
        boolean isUnhealthy = this.uris.stream().noneMatch(rv -> ((RankValue)rv.getValue()).getCostTime().get() != Long.MAX_VALUE);
        this.uris = !isUnhealthy ? this.uris.stream().filter(rv -> ((RankValue)rv.getValue()).getCostTime().get() != Long.MAX_VALUE).sorted(Comparator.comparingInt(entry -> ((RankValue)entry.getValue()).getAppNum().get())).collect(Collectors.toList()) : this.uris.stream().sorted(Comparator.comparingInt(entry -> ((RankValue)entry.getValue()).getAppNum().get())).collect(Collectors.toList());
        LOG.info("The sorted remote path list is: {}", (Object)this.uris);
        for (Map.Entry entry2 : this.uris) {
            String storagePath = (String)entry2.getKey();
            if (!this.availableRemoteStorageInfo.containsKey(storagePath)) continue;
            return this.appIdToRemoteStorageInfo.computeIfAbsent(appId, x -> this.availableRemoteStorageInfo.get(storagePath));
        }
        LOG.warn("No remote storage is available, we will default to the first.");
        return this.availableRemoteStorageInfo.values().iterator().next();
    }
}

